/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.support.annotation.Nullable;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public class DiscardableReferencePool {
    private final Set<DiscardableReference<?>> mPool;

    public DiscardableReferencePool() {
        WeakHashMap map = new WeakHashMap();
        this.mPool = Collections.newSetFromMap(map);
    }

    public <T> DiscardableReference<T> put(T payload) {
        assert (payload != null);
        DiscardableReference reference = new DiscardableReference(payload);
        this.mPool.add(reference);
        return reference;
    }

    public void remove(DiscardableReference<?> ref) {
        assert (ref != null);
        if (!this.mPool.contains(ref)) {
            return;
        }
        assert (ref.get() != null);
        ((DiscardableReference)ref).discard();
        this.mPool.remove(ref);
    }

    public void drain() {
        for (DiscardableReference<?> ref : this.mPool) {
            ((DiscardableReference)ref).discard();
        }
        this.mPool.clear();
    }

    public static class DiscardableReference<T> {
        @Nullable
        private T mPayload;

        private DiscardableReference(T payload) {
            assert (payload != null);
            this.mPayload = payload;
        }

        @Nullable
        public T get() {
            return this.mPayload;
        }

        private void discard() {
            assert (this.mPayload != null);
            this.mPayload = null;
        }
    }
}

