/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Process;
import android.os.StrictMode;
import android.os.SystemClock;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.TimeUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="base::android")
@MainDex
public class EarlyTraceEvent {
    private static final String TRACE_CONFIG_FILENAME = "/data/local/chrome-trace-config.json";
    @VisibleForTesting
    static final int STATE_DISABLED = 0;
    @VisibleForTesting
    static final int STATE_ENABLED = 1;
    @VisibleForTesting
    static final int STATE_FINISHING = 2;
    @VisibleForTesting
    static final int STATE_FINISHED = 3;
    private static final String BACKGROUND_STARTUP_TRACING_ENABLED_KEY = "bg_startup_tracing";
    private static boolean sCachedBackgroundStartupTracingFlag;
    private static final Object sLock;
    @VisibleForTesting
    static volatile int sState;
    @GuardedBy(value="sLock")
    @VisibleForTesting
    static List<Event> sCompletedEvents;
    @GuardedBy(value="sLock")
    @VisibleForTesting
    static Map<String, Event> sPendingEventByKey;
    @GuardedBy(value="sLock")
    @VisibleForTesting
    static List<AsyncEvent> sAsyncEvents;
    @GuardedBy(value="sLock")
    @VisibleForTesting
    static List<String> sPendingAsyncEvents;

    static void maybeEnable() {
        ThreadUtils.assertOnUiThread();
        if (sState != 0) {
            return;
        }
        boolean shouldEnable = false;
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            if (CommandLine.getInstance().hasSwitch("trace-startup")) {
                shouldEnable = true;
            } else {
                try {
                    shouldEnable = new File(TRACE_CONFIG_FILENAME).exists();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (ContextUtils.getAppSharedPreferences().getBoolean(BACKGROUND_STARTUP_TRACING_ENABLED_KEY, false)) {
                if (shouldEnable) {
                    EarlyTraceEvent.setBackgroundStartupTracingFlag(false);
                    sCachedBackgroundStartupTracingFlag = false;
                } else {
                    sCachedBackgroundStartupTracingFlag = true;
                    shouldEnable = true;
                }
            }
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
        if (shouldEnable) {
            EarlyTraceEvent.enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void enable() {
        Object object = sLock;
        synchronized (object) {
            if (sState != 0) {
                return;
            }
            sCompletedEvents = new ArrayList<Event>();
            sPendingEventByKey = new HashMap<String, Event>();
            sAsyncEvents = new ArrayList<AsyncEvent>();
            sPendingAsyncEvents = new ArrayList<String>();
            sState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disable() {
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            sState = 2;
            EarlyTraceEvent.maybeFinishLocked();
        }
    }

    static boolean isActive() {
        int state = sState;
        return state == 1 || state == 2;
    }

    static boolean enabled() {
        return sState == 1;
    }

    @CalledByNative
    static void setBackgroundStartupTracingFlag(boolean enabled) {
        ContextUtils.getAppSharedPreferences().edit().putBoolean(BACKGROUND_STARTUP_TRACING_ENABLED_KEY, enabled).apply();
    }

    @CalledByNative
    public static boolean getBackgroundStartupTracingFlag() {
        return sCachedBackgroundStartupTracingFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void begin(String name) {
        Event conflictingEvent;
        if (!EarlyTraceEvent.enabled()) {
            return;
        }
        Event event = new Event(name);
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            conflictingEvent = sPendingEventByKey.put(EarlyTraceEvent.makeEventKeyForCurrentThread(name), event);
        }
        if (conflictingEvent != null) {
            throw new IllegalArgumentException("Multiple pending trace events can't have the same name: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end(String name) {
        if (!EarlyTraceEvent.isActive()) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.isActive()) {
                return;
            }
            Event event = sPendingEventByKey.remove(EarlyTraceEvent.makeEventKeyForCurrentThread(name));
            if (event == null) {
                return;
            }
            event.end();
            sCompletedEvents.add(event);
            if (sState == 2) {
                EarlyTraceEvent.maybeFinishLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEvent(Event e) {
        if (!EarlyTraceEvent.enabled()) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            sCompletedEvents.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAsync(String name, long id2) {
        if (!EarlyTraceEvent.enabled()) {
            return;
        }
        AsyncEvent event = new AsyncEvent(name, id2, true);
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.enabled()) {
                return;
            }
            sAsyncEvents.add(event);
            sPendingAsyncEvents.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishAsync(String name, long id2) {
        if (!EarlyTraceEvent.isActive()) {
            return;
        }
        AsyncEvent event = new AsyncEvent(name, id2, false);
        Object object = sLock;
        synchronized (object) {
            if (!EarlyTraceEvent.isActive()) {
                return;
            }
            if (!sPendingAsyncEvents.remove(name)) {
                return;
            }
            sAsyncEvents.add(event);
            if (sState == 2) {
                EarlyTraceEvent.maybeFinishLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void resetForTesting() {
        Object object = sLock;
        synchronized (object) {
            sState = 0;
            sCompletedEvents = null;
            sPendingEventByKey = null;
            sAsyncEvents = null;
            sPendingAsyncEvents = null;
        }
    }

    @GuardedBy(value="sLock")
    private static void maybeFinishLocked() {
        if (!sCompletedEvents.isEmpty()) {
            EarlyTraceEvent.dumpEvents(sCompletedEvents);
            sCompletedEvents.clear();
        }
        if (!sAsyncEvents.isEmpty()) {
            EarlyTraceEvent.dumpAsyncEvents(sAsyncEvents);
            sAsyncEvents.clear();
        }
        if (sPendingEventByKey.isEmpty() && sPendingAsyncEvents.isEmpty()) {
            sState = 3;
            sPendingEventByKey = null;
            sCompletedEvents = null;
            sPendingAsyncEvents = null;
            sAsyncEvents = null;
        }
    }

    private static void dumpEvents(List<Event> events) {
        long offsetNanos = EarlyTraceEvent.getOffsetNanos();
        for (Event e : events) {
            EarlyTraceEvent.nativeRecordEarlyEvent(e.mName, e.mBeginTimeNanos + offsetNanos, e.mEndTimeNanos + offsetNanos, e.mThreadId, e.mEndThreadTimeMillis - e.mBeginThreadTimeMillis);
        }
    }

    private static void dumpAsyncEvents(List<AsyncEvent> events) {
        long offsetNanos = EarlyTraceEvent.getOffsetNanos();
        for (AsyncEvent e : events) {
            if (e.mIsStart) {
                EarlyTraceEvent.nativeRecordEarlyStartAsyncEvent(e.mName, e.mId, e.mTimestampNanos + offsetNanos);
                continue;
            }
            EarlyTraceEvent.nativeRecordEarlyFinishAsyncEvent(e.mName, e.mId, e.mTimestampNanos + offsetNanos);
        }
    }

    private static long getOffsetNanos() {
        long nativeNowNanos = TimeUtils.nativeGetTimeTicksNowUs() * 1000L;
        long javaNowNanos = Event.elapsedRealtimeNanos();
        return nativeNowNanos - javaNowNanos;
    }

    @VisibleForTesting
    static String makeEventKeyForCurrentThread(String name) {
        return name + "@" + Process.myTid();
    }

    private static native void nativeRecordEarlyEvent(String var0, long var1, long var3, int var5, long var6);

    private static native void nativeRecordEarlyStartAsyncEvent(String var0, long var1, long var3);

    private static native void nativeRecordEarlyFinishAsyncEvent(String var0, long var1, long var3);

    static {
        sLock = new Object();
        sState = 0;
    }

    @VisibleForTesting
    static final class AsyncEvent {
        final boolean mIsStart;
        final String mName;
        final long mId;
        final long mTimestampNanos;

        AsyncEvent(String name, long id2, boolean isStart) {
            this.mName = name;
            this.mId = id2;
            this.mIsStart = isStart;
            this.mTimestampNanos = Event.elapsedRealtimeNanos();
        }
    }

    public static final class Event {
        final String mName;
        final int mThreadId;
        final long mBeginTimeNanos;
        final long mBeginThreadTimeMillis;
        long mEndTimeNanos;
        long mEndThreadTimeMillis;

        public Event(String name) {
            this.mName = name;
            this.mThreadId = Process.myTid();
            this.mBeginTimeNanos = Event.elapsedRealtimeNanos();
            this.mBeginThreadTimeMillis = SystemClock.currentThreadTimeMillis();
        }

        public void end() {
            assert (this.mEndTimeNanos == 0L);
            assert (this.mEndThreadTimeMillis == 0L);
            this.mEndTimeNanos = Event.elapsedRealtimeNanos();
            this.mEndThreadTimeMillis = SystemClock.currentThreadTimeMillis();
        }

        @VisibleForTesting
        @SuppressLint(value={"NewApi"})
        static long elapsedRealtimeNanos() {
            if (Build.VERSION.SDK_INT >= 17) {
                return SystemClock.elapsedRealtimeNanos();
            }
            return SystemClock.elapsedRealtime() * 1000000L;
        }
    }
}

