/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import org.chromium.base.ContentUriUtils;
import org.chromium.base.Log;

public class FileUtils {
    private static final String TAG = "FileUtils";

    public static boolean recursivelyDeleteFile(File currentFile) {
        boolean ret;
        File[] files;
        if (!currentFile.exists()) {
            return true;
        }
        if (currentFile.isDirectory() && (files = currentFile.listFiles()) != null) {
            for (File file : files) {
                FileUtils.recursivelyDeleteFile(file);
            }
        }
        if (!(ret = currentFile.delete())) {
            Log.e(TAG, "Failed to delete: %s", currentFile);
        }
        return ret;
    }

    public static void batchDeleteFiles(List<String> filePaths) {
        for (String filePath : filePaths) {
            if (ContentUriUtils.isContentUri(filePath)) {
                ContentUriUtils.delete(filePath);
                continue;
            }
            File file = new File(filePath);
            if (!file.exists()) continue;
            FileUtils.recursivelyDeleteFile(file);
        }
    }

    public static boolean extractAsset(Context context, String assetName, File outFile) {
        boolean bl;
        block8: {
            InputStream inputStream = context.getAssets().open(assetName);
            Throwable throwable = null;
            try {
                FileUtils.copyStreamToFile(inputStream, outFile);
                bl = true;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (inputStream != null) {
                            FileUtils.$closeResource(throwable, inputStream);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    return false;
                }
            }
            FileUtils.$closeResource(throwable, inputStream);
        }
        return bl;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int amountRead;
        byte[] buffer = new byte[8192];
        while ((amountRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, amountRead);
        }
    }

    public static void copyStreamToFile(InputStream is, File outFile) throws IOException {
        File tmpOutputFile = new File(outFile.getPath() + ".tmp");
        try (FileOutputStream os = new FileOutputStream(tmpOutputFile);){
            Log.i(TAG, "Writing to %s", outFile);
            FileUtils.copyStream(is, os);
        }
        if (!tmpOutputFile.renameTo(outFile)) {
            throw new IOException();
        }
    }

    @NonNull
    public static byte[] readStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        FileUtils.copyStream(inputStream, data);
        return data.toByteArray();
    }

    public static Uri getUriForFile(File file) {
        Uri uri = null;
        try {
            uri = ContentUriUtils.getContentUriFromFile(file);
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Could not create content uri: " + e, new Object[0]);
        }
        if (uri == null) {
            uri = Uri.fromFile((File)file);
        }
        return uri;
    }

    public static String getExtension(String file) {
        int index = file.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return file.substring(index + 1).toLowerCase(Locale.US);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Bitmap queryBitmapFromContentProvider(Context context, Uri uri) {
        try (ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");){
            if (parcelFileDescriptor == null) {
                Log.w(TAG, "Null ParcelFileDescriptor from uri " + uri, new Object[0]);
                Bitmap bitmap = null;
                return bitmap;
            }
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            if (fileDescriptor == null) {
                Log.w(TAG, "Null FileDescriptor from uri " + uri, new Object[0]);
                Bitmap bitmap = null;
                return bitmap;
            }
            Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor);
            if (bitmap == null) {
                Log.w(TAG, "Failed to decode image from uri " + uri, new Object[0]);
                Bitmap bitmap2 = null;
                return bitmap2;
            }
            Bitmap bitmap3 = bitmap;
            return bitmap3;
        }
        catch (IOException e) {
            Log.w(TAG, "IO exception when reading uri " + uri, new Object[0]);
            return null;
        }
    }
}

