/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="base::android")
@MainDex
public class JavaHandlerThread {
    private final HandlerThread mThread;
    private Throwable mUnhandledException;

    public JavaHandlerThread(String name, int priority) {
        this.mThread = new HandlerThread(name, priority);
    }

    @CalledByNative
    private static JavaHandlerThread create(String name, int priority) {
        return new JavaHandlerThread(name, priority);
    }

    public Looper getLooper() {
        assert (this.hasStarted());
        return this.mThread.getLooper();
    }

    public void maybeStart() {
        if (this.hasStarted()) {
            return;
        }
        this.mThread.start();
    }

    @CalledByNative
    private void startAndInitialize(final long nativeThread, final long nativeEvent) {
        this.maybeStart();
        new Handler(this.mThread.getLooper()).post(new Runnable(){

            @Override
            public void run() {
                JavaHandlerThread.this.nativeInitializeThread(nativeThread, nativeEvent);
            }
        });
    }

    @CalledByNative
    private void quitThreadSafely(final long nativeThread) {
        new Handler(this.mThread.getLooper()).post(new Runnable(){

            @Override
            public void run() {
                JavaHandlerThread.this.mThread.quit();
                JavaHandlerThread.this.nativeOnLooperStopped(nativeThread);
            }
        });
        if (Build.VERSION.SDK_INT >= 18) {
            this.mThread.getLooper().quitSafely();
        }
    }

    @CalledByNative
    private void joinThread() {
        boolean joined = false;
        while (!joined) {
            try {
                this.mThread.join();
                joined = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean hasStarted() {
        return this.mThread.getState() != Thread.State.NEW;
    }

    @CalledByNative
    private boolean isAlive() {
        return this.mThread.isAlive();
    }

    @CalledByNative
    private void listenForUncaughtExceptionsForTesting() {
        this.mThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                JavaHandlerThread.this.mUnhandledException = e;
            }
        });
    }

    @CalledByNative
    private Throwable getUncaughtExceptionIfAny() {
        return this.mUnhandledException;
    }

    private native void nativeInitializeThread(long var1, long var3);

    private native void nativeOnLooperStopped(long var1);
}

