/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.support.annotation.VisibleForTesting;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.chromium.base.BuildConfig;

public class LifetimeAssert {
    static TestHook sTestHook;
    @VisibleForTesting
    final WrappedReference mWrapper;

    private LifetimeAssert(WrappedReference wrapper) {
        this.mWrapper = wrapper;
    }

    public static LifetimeAssert create(Object target) {
        if (!BuildConfig.DCHECK_IS_ON) {
            return null;
        }
        return new LifetimeAssert(new WrappedReference(target, new CreationException(), false));
    }

    public static LifetimeAssert create(Object target, boolean safeToGc) {
        if (!BuildConfig.DCHECK_IS_ON) {
            return null;
        }
        return new LifetimeAssert(new WrappedReference(target, new CreationException(), safeToGc));
    }

    public static void setSafeToGc(LifetimeAssert asserter, boolean value) {
        if (BuildConfig.DCHECK_IS_ON) {
            asserter.mWrapper.mSafeToGc = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertAllInstancesDestroyedForTesting() throws LifetimeAssertException {
        if (!BuildConfig.DCHECK_IS_ON) {
            return;
        }
        Set set = WrappedReference.sActiveWrappers;
        synchronized (set) {
            for (WrappedReference ref : WrappedReference.sActiveWrappers) {
                if (ref.mSafeToGc) continue;
                String msg = String.format("Object of type %s was not destroyed after test completed. Refer to \"Caused by\" for where object was created.", ref.mTargetClass.getName());
                throw new LifetimeAssertException(msg, ref.mCreationException);
            }
        }
    }

    @VisibleForTesting
    static class WrappedReference
    extends PhantomReference<Object> {
        boolean mSafeToGc;
        final Class<?> mTargetClass;
        final CreationException mCreationException;
        private static ReferenceQueue<Object> sReferenceQueue = new ReferenceQueue();
        private static Set<WrappedReference> sActiveWrappers = Collections.synchronizedSet(new HashSet());

        public WrappedReference(Object target, CreationException creationException, boolean safeToGc) {
            super(target, sReferenceQueue);
            this.mCreationException = creationException;
            this.mSafeToGc = safeToGc;
            this.mTargetClass = target.getClass();
            sActiveWrappers.add(this);
        }

        static {
            new Thread("GcStateAssertQueue"){
                {
                    this.setDaemon(true);
                    this.start();
                }

                @Override
                public void run() {
                    try {
                        while (true) {
                            WrappedReference wrapper = (WrappedReference)sReferenceQueue.remove();
                            sActiveWrappers.remove(wrapper);
                            if (!wrapper.mSafeToGc) {
                                String msg = String.format("Object of type %s was GC'ed without cleanup. Refer to \"Caused by\" for where object was created.", wrapper.mTargetClass.getName());
                                if (sTestHook != null) {
                                    sTestHook.onCleaned(wrapper, msg);
                                    continue;
                                }
                                throw new LifetimeAssertException(msg, wrapper.mCreationException);
                            }
                            if (sTestHook == null) continue;
                            sTestHook.onCleaned(wrapper, null);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }

    private static class CreationException
    extends RuntimeException {
        CreationException() {
            super("vvv This is where object was created. vvv");
        }
    }

    static class LifetimeAssertException
    extends RuntimeException {
        LifetimeAssertException(String msg, Throwable causedBy) {
            super(msg, causedBy);
        }
    }

    static interface TestHook {
        public void onCleaned(WrappedReference var1, String var2);
    }
}

