/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Locale;
import org.chromium.base.BuildConfig;
import org.chromium.base.CommandLine;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;

public class LocaleUtils {
    private LocaleUtils() {
    }

    public static String getUpdatedLanguageForChromium(String language) {
        switch (language) {
            case "iw": {
                return "he";
            }
            case "ji": {
                return "yi";
            }
            case "in": {
                return "id";
            }
            case "tl": {
                return "fil";
            }
        }
        return language;
    }

    @TargetApi(value=21)
    @VisibleForTesting
    public static Locale getUpdatedLocaleForChromium(Locale locale) {
        String language = locale.getLanguage();
        String languageForChrome = LocaleUtils.getUpdatedLanguageForChromium(language);
        if (languageForChrome.equals(language)) {
            return locale;
        }
        return new Locale.Builder().setLocale(locale).setLanguage(languageForChrome).build();
    }

    public static String getUpdatedLanguageForAndroid(String language) {
        switch (language) {
            case "und": {
                return "";
            }
            case "fil": {
                return "tl";
            }
        }
        return language;
    }

    @TargetApi(value=21)
    @VisibleForTesting
    public static Locale getUpdatedLocaleForAndroid(Locale locale) {
        String language = locale.getLanguage();
        String languageForAndroid = LocaleUtils.getUpdatedLanguageForAndroid(language);
        if (languageForAndroid.equals(language)) {
            return locale;
        }
        return new Locale.Builder().setLocale(locale).setLanguage(languageForAndroid).build();
    }

    public static Locale forLanguageTagCompat(String languageTag) {
        String[] tag = languageTag.split("-");
        if (tag.length == 0) {
            return new Locale("");
        }
        String language = LocaleUtils.getUpdatedLanguageForAndroid(tag[0]);
        if (language.length() != 2 && language.length() != 3) {
            return new Locale("");
        }
        if (tag.length == 1) {
            return new Locale(language);
        }
        String country = tag[1];
        if (country.length() != 2 && country.length() != 3) {
            return new Locale(language);
        }
        return new Locale(language, country);
    }

    public static Locale forLanguageTag(String languageTag) {
        if (Build.VERSION.SDK_INT >= 21) {
            Locale locale = Locale.forLanguageTag(languageTag);
            return LocaleUtils.getUpdatedLocaleForAndroid(locale);
        }
        return LocaleUtils.forLanguageTagCompat(languageTag);
    }

    public static String toLanguageTag(Locale locale) {
        String language = LocaleUtils.getUpdatedLanguageForChromium(locale.getLanguage());
        String country = locale.getCountry();
        if (language.equals("no") && country.equals("NO") && locale.getVariant().equals("NY")) {
            return "nn-NO";
        }
        return country.isEmpty() ? language : language + "-" + country;
    }

    @TargetApi(value=24)
    public static String toLanguageTags(LocaleList localeList) {
        ArrayList<String> newLocaleList = new ArrayList<String>();
        for (int i = 0; i < localeList.size(); ++i) {
            Locale locale = LocaleUtils.getUpdatedLocaleForChromium(localeList.get(i));
            newLocaleList.add(LocaleUtils.toLanguageTag(locale));
        }
        return TextUtils.join((CharSequence)",", newLocaleList);
    }

    public static String toLanguage(String languageTag) {
        int pos = languageTag.indexOf(45);
        if (pos < 0) {
            return languageTag;
        }
        return languageTag.substring(0, pos);
    }

    public static boolean isLanguageSupported(String language) {
        for (String languageTag : BuildConfig.COMPRESSED_LOCALES) {
            if (!LocaleUtils.toLanguage(languageTag).equals(language)) continue;
            return true;
        }
        return false;
    }

    @CalledByNative
    public static String getDefaultLocaleString() {
        return LocaleUtils.toLanguageTag(Locale.getDefault());
    }

    public static String getDefaultLocaleListString() {
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleUtils.toLanguageTags(LocaleList.getDefault());
        }
        return LocaleUtils.getDefaultLocaleString();
    }

    @CalledByNative
    private static String getDefaultCountryCode() {
        CommandLine commandLine = CommandLine.getInstance();
        return commandLine.hasSwitch("default-country-code") ? commandLine.getSwitchValue("default-country-code") : Locale.getDefault().getCountry();
    }
}

