/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import java.util.Locale;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.RemovableInRelease;

public class Log {
    public static final int ASSERT = 7;
    public static final int DEBUG = 3;
    public static final int ERROR = 6;
    public static final int INFO = 4;
    public static final int VERBOSE = 2;
    public static final int WARN = 5;
    private static final String sTagPrefix = "cr_";
    private static final String sDeprecatedTagPrefix = "cr.";

    private Log() {
    }

    private static String formatLog(String messageTemplate, Object ... params) {
        if (params != null && params.length != 0) {
            messageTemplate = String.format(Locale.US, messageTemplate, params);
        }
        return messageTemplate;
    }

    public static String normalizeTag(String tag) {
        if (tag.startsWith(sTagPrefix)) {
            return tag;
        }
        int unprefixedTagStart = 0;
        if (tag.startsWith(sDeprecatedTagPrefix)) {
            unprefixedTagStart = sDeprecatedTagPrefix.length();
        }
        return sTagPrefix + tag.substring(unprefixedTagStart, tag.length());
    }

    private static String formatLogWithStack(String messageTemplate, Object ... params) {
        return "[" + Log.getCallOrigin() + "] " + Log.formatLog(messageTemplate, params);
    }

    public static boolean isLoggable(String tag, int level) {
        return android.util.Log.isLoggable((String)tag, (int)level);
    }

    private static void verbose(String tag, String messageTemplate, Object ... args) {
        String message = Log.formatLogWithStack(messageTemplate, args);
        Throwable tr = Log.getThrowableToLog(args);
        if (tr != null) {
            android.util.Log.v((String)Log.normalizeTag(tag), (String)message, (Throwable)tr);
        } else {
            android.util.Log.v((String)Log.normalizeTag(tag), (String)message);
        }
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void v(String tag, String message) {
        Log.verbose(tag, message, new Object[0]);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void v(String tag, String messageTemplate, Object arg1) {
        Log.verbose(tag, messageTemplate, arg1);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void v(String tag, String messageTemplate, Object arg1, Object arg2) {
        Log.verbose(tag, messageTemplate, arg1, arg2);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void v(String tag, String messageTemplate, Object arg1, Object arg2, Object arg3) {
        Log.verbose(tag, messageTemplate, arg1, arg2, arg3);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void v(String tag, String messageTemplate, Object arg1, Object arg2, Object arg3, Object arg4) {
        Log.verbose(tag, messageTemplate, arg1, arg2, arg3, arg4);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void v(String tag, String messageTemplate, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Log.verbose(tag, messageTemplate, arg1, arg2, arg3, arg4, arg5);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void v(String tag, String messageTemplate, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        Log.verbose(tag, messageTemplate, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void v(String tag, String messageTemplate, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        Log.verbose(tag, messageTemplate, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    private static void debug(String tag, String messageTemplate, Object ... args) {
        String message = Log.formatLogWithStack(messageTemplate, args);
        Throwable tr = Log.getThrowableToLog(args);
        if (tr != null) {
            android.util.Log.d((String)Log.normalizeTag(tag), (String)message, (Throwable)tr);
        } else {
            android.util.Log.d((String)Log.normalizeTag(tag), (String)message);
        }
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void d(String tag, String message) {
        Log.debug(tag, message, new Object[0]);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void d(String tag, String messageTemplate, Object arg1) {
        Log.debug(tag, messageTemplate, arg1);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void d(String tag, String messageTemplate, Object arg1, Object arg2) {
        Log.debug(tag, messageTemplate, arg1, arg2);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void d(String tag, String messageTemplate, Object arg1, Object arg2, Object arg3) {
        Log.debug(tag, messageTemplate, arg1, arg2, arg3);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void d(String tag, String messageTemplate, Object arg1, Object arg2, Object arg3, Object arg4) {
        Log.debug(tag, messageTemplate, arg1, arg2, arg3, arg4);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void d(String tag, String messageTemplate, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Log.debug(tag, messageTemplate, arg1, arg2, arg3, arg4, arg5);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void d(String tag, String messageTemplate, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        Log.debug(tag, messageTemplate, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @RemovableInRelease
    @VisibleForTesting
    public static void d(String tag, String messageTemplate, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        Log.debug(tag, messageTemplate, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    @VisibleForTesting
    public static void i(String tag, String messageTemplate, Object ... args) {
        String message = Log.formatLog(messageTemplate, args);
        Throwable tr = Log.getThrowableToLog(args);
        if (tr != null) {
            android.util.Log.i((String)Log.normalizeTag(tag), (String)message, (Throwable)tr);
        } else {
            android.util.Log.i((String)Log.normalizeTag(tag), (String)message);
        }
    }

    @VisibleForTesting
    public static void w(String tag, String messageTemplate, Object ... args) {
        String message = Log.formatLog(messageTemplate, args);
        Throwable tr = Log.getThrowableToLog(args);
        if (tr != null) {
            android.util.Log.w((String)Log.normalizeTag(tag), (String)message, (Throwable)tr);
        } else {
            android.util.Log.w((String)Log.normalizeTag(tag), (String)message);
        }
    }

    @VisibleForTesting
    public static void e(String tag, String messageTemplate, Object ... args) {
        String message = Log.formatLog(messageTemplate, args);
        Throwable tr = Log.getThrowableToLog(args);
        if (tr != null) {
            android.util.Log.e((String)Log.normalizeTag(tag), (String)message, (Throwable)tr);
        } else {
            android.util.Log.e((String)Log.normalizeTag(tag), (String)message);
        }
    }

    @VisibleForTesting
    public static void wtf(String tag, String messageTemplate, Object ... args) {
        String message = Log.formatLog(messageTemplate, args);
        Throwable tr = Log.getThrowableToLog(args);
        if (tr != null) {
            android.util.Log.wtf((String)Log.normalizeTag(tag), (String)message, (Throwable)tr);
        } else {
            android.util.Log.wtf((String)Log.normalizeTag(tag), (String)message);
        }
    }

    public static String getStackTraceString(Throwable tr) {
        return android.util.Log.getStackTraceString((Throwable)tr);
    }

    private static Throwable getThrowableToLog(Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        Object lastArg = args[args.length - 1];
        if (!(lastArg instanceof Throwable)) {
            return null;
        }
        return (Throwable)lastArg;
    }

    private static String getCallOrigin() {
        int callerStackIndex;
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        String logClassName = Log.class.getName();
        for (callerStackIndex = 0; callerStackIndex < st.length; ++callerStackIndex) {
            if (!st[callerStackIndex].getClassName().equals(logClassName)) continue;
            callerStackIndex += 4;
            break;
        }
        return st[callerStackIndex].getFileName() + ":" + st[callerStackIndex].getLineNumber();
    }
}

