/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Handler;
import android.support.annotation.Nullable;
import org.chromium.base.Callback;
import org.chromium.base.ObservableSupplier;
import org.chromium.base.ObserverList;

public class ObservableSupplierImpl<E>
implements ObservableSupplier<E> {
    private final Thread mThread = Thread.currentThread();
    private final Handler mHandler = new Handler();
    private E mObject;
    private final ObserverList<Callback<E>> mObservers = new ObserverList();

    @Override
    public E addObserver(Callback<E> obs) {
        this.checkThread();
        this.mObservers.addObserver(obs);
        if (this.mObject != null) {
            E currentObject = this.mObject;
            this.mHandler.post(() -> {
                if (this.mObject != currentObject || !this.mObservers.hasObserver(obs)) {
                    return;
                }
                obs.onResult(this.mObject);
            });
        }
        return this.mObject;
    }

    @Override
    public void removeObserver(Callback<E> obs) {
        this.checkThread();
        this.mObservers.removeObserver(obs);
    }

    public void set(E object) {
        this.checkThread();
        if (object == this.mObject) {
            return;
        }
        this.mObject = object;
        for (Callback<E> observer : this.mObservers) {
            observer.onResult(this.mObject);
        }
    }

    @Override
    @Nullable
    public E get() {
        this.checkThread();
        return this.mObject;
    }

    private void checkThread() {
        assert (this.mThread == Thread.currentThread()) : "ObservableSupplierImpl must only be used on a single Thread.";
    }
}

