/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Environment;
import android.os.SystemClock;
import android.system.Os;
import android.text.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.chromium.base.BuildInfo;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.StrictModeContext;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.base.task.AsyncTask;

@MainDex
public abstract class PathUtils {
    private static final String TAG = "PathUtils";
    private static final String THUMBNAIL_DIRECTORY_NAME = "textures";
    private static final int DATA_DIRECTORY = 0;
    private static final int THUMBNAIL_DIRECTORY = 1;
    private static final int CACHE_DIRECTORY = 2;
    private static final int NUM_DIRECTORIES = 3;
    private static final AtomicBoolean sInitializationStarted = new AtomicBoolean();
    private static FutureTask<String[]> sDirPathFetchTask;
    private static String sDataDirectorySuffix;
    private static String sCacheSubDirectory;

    private PathUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] getOrComputeDirectoryPaths() {
        try {
            if (!sDirPathFetchTask.cancel(false)) return sDirPathFetchTask.get();
            try (StrictModeContext unused = StrictModeContext.allowDiskWrites();){
                String[] stringArray = PathUtils.setPrivateDataDirectorySuffixInternal();
                return stringArray;
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private static void chmod(String path, int mode) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        try {
            Os.chmod((String)path, (int)mode);
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to set permissions for path \"" + path + "\"", new Object[0]);
        }
    }

    private static String[] setPrivateDataDirectorySuffixInternal() {
        String[] paths = new String[3];
        Context appContext = ContextUtils.getApplicationContext();
        paths[0] = appContext.getDir(sDataDirectorySuffix, 0).getPath();
        PathUtils.chmod(paths[0], 448);
        paths[1] = appContext.getDir(THUMBNAIL_DIRECTORY_NAME, 0).getPath();
        if (appContext.getCacheDir() != null) {
            paths[2] = sCacheSubDirectory == null ? appContext.getCacheDir().getPath() : new File(appContext.getCacheDir(), sCacheSubDirectory).getPath();
        }
        return paths;
    }

    public static void setPrivateDataDirectorySuffix(String suffix, String cacheSubDir) {
        if (!sInitializationStarted.getAndSet(true)) {
            assert (ContextUtils.getApplicationContext() != null);
            sDataDirectorySuffix = suffix;
            sCacheSubDirectory = cacheSubDir;
            sDirPathFetchTask = new FutureTask<String[]>(PathUtils::setPrivateDataDirectorySuffixInternal);
            AsyncTask.THREAD_POOL_EXECUTOR.execute(sDirPathFetchTask);
        }
    }

    public static void setPrivateDataDirectorySuffix(String suffix) {
        PathUtils.setPrivateDataDirectorySuffix(suffix, null);
    }

    private static String getDirectoryPath(int index) {
        return Holder.DIRECTORY_PATHS[index];
    }

    @CalledByNative
    public static String getDataDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(0);
    }

    @CalledByNative
    public static String getCacheDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(2);
    }

    @CalledByNative
    public static String getThumbnailCacheDirectory() {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(1);
    }

    @CalledByNative
    private static String getDownloadsDirectory() {
        try (StrictModeContext unused = StrictModeContext.allowDiskReads();){
            long time = SystemClock.elapsedRealtime();
            String downloadsPath = BuildInfo.isAtLeastQ() ? PathUtils.getAllPrivateDownloadsDirectories()[0] : Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
            RecordHistogram.recordTimesHistogram("Android.StrictMode.DownloadsDir", SystemClock.elapsedRealtime() - time);
            String string2 = downloadsPath;
            return string2;
        }
    }

    @CalledByNative
    public static String[] getAllPrivateDownloadsDirectories() {
        File[] files;
        if (Build.VERSION.SDK_INT >= 19) {
            try (StrictModeContext unused = StrictModeContext.allowDiskWrites();){
                files = ContextUtils.getApplicationContext().getExternalFilesDirs(Environment.DIRECTORY_DOWNLOADS);
            }
        } else {
            files = new File[]{Environment.getExternalStorageDirectory()};
        }
        ArrayList<String> absolutePaths = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null || TextUtils.isEmpty((CharSequence)files[i].getAbsolutePath())) continue;
            absolutePaths.add(files[i].getAbsolutePath());
        }
        return absolutePaths.toArray(new String[absolutePaths.size()]);
    }

    @CalledByNative
    private static String getNativeLibraryDirectory() {
        ApplicationInfo ai = ContextUtils.getApplicationContext().getApplicationInfo();
        if ((ai.flags & 0x80) != 0 || (ai.flags & 1) == 0) {
            return ai.nativeLibraryDir;
        }
        return "/system/lib/";
    }

    @CalledByNative
    public static String getExternalStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    static /* synthetic */ String[] access$000() {
        return PathUtils.getOrComputeDirectoryPaths();
    }

    private static class Holder {
        private static final String[] DIRECTORY_PATHS = PathUtils.access$000();

        private Holder() {
        }
    }
}

