/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.SuppressLint;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandom;

@SuppressLint(value={"SecureRandom"})
public class SecureRandomInitializer {
    private static final int NUM_RANDOM_BYTES = 16;

    public static void initialize(SecureRandom generator) throws IOException {
        try (FileInputStream fis = new FileInputStream("/dev/urandom");){
            byte[] seedBytes = new byte[16];
            if (fis.read(seedBytes) != seedBytes.length) {
                throw new IOException("Failed to get enough random data.");
            }
            generator.setSeed(seedBytes);
        }
    }
}

