/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Process;
import java.util.HashMap;
import org.chromium.base.UserData;

public final class UserDataHost {
    private final long mThreadId = Process.myTid();
    private HashMap<Class<? extends UserData>, UserData> mUserDataMap = new HashMap();

    private void checkThreadAndState() {
        assert (this.mThreadId == (long)Process.myTid()) : "UserData must only be used on a single thread.";
        assert (this.mUserDataMap != null) : "Operation is not allowed after destroy()";
    }

    public <T extends UserData> T setUserData(Class<T> key, T object) {
        this.checkThreadAndState();
        assert (key != null && object != null) : "Neither key nor object of UserDataHost can be null";
        this.mUserDataMap.put(key, object);
        return this.getUserData(key);
    }

    public <T extends UserData> T getUserData(Class<T> key) {
        this.checkThreadAndState();
        assert (key != null) : "UserDataHost key cannot be null";
        return (T)((UserData)key.cast(this.mUserDataMap.get(key)));
    }

    public <T extends UserData> T removeUserData(Class<T> key) {
        this.checkThreadAndState();
        assert (key != null) : "UserDataHost key cannot be null";
        assert (this.mUserDataMap.containsKey(key)) : "UserData for the key is not present";
        return (T)((UserData)key.cast(this.mUserDataMap.remove(key)));
    }

    public void destroy() {
        this.checkThreadAndState();
        HashMap<Class<? extends UserData>, UserData> map = this.mUserDataMap;
        this.mUserDataMap = null;
        for (UserData userData : map.values()) {
            userData.destroy();
        }
    }
}

