/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.memory;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.metrics.RecordHistogram;

public class MemoryPressureUma
implements ComponentCallbacks2 {
    private final String mHistogramName;
    private static MemoryPressureUma sInstance;

    public static void initializeForBrowser() {
        MemoryPressureUma.initializeInstance("Browser");
    }

    public static void initializeForChildService() {
        MemoryPressureUma.initializeInstance("ChildService");
    }

    private static void initializeInstance(String processType) {
        ThreadUtils.assertOnUiThread();
        assert (sInstance == null);
        sInstance = new MemoryPressureUma(processType);
        ContextUtils.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)sInstance);
    }

    private MemoryPressureUma(String processType) {
        this.mHistogramName = "Android.MemoryPressureNotification." + processType;
    }

    public void onLowMemory() {
        this.record(8);
    }

    public void onTrimMemory(int level) {
        switch (level) {
            case 80: {
                this.record(1);
                break;
            }
            case 60: {
                this.record(2);
                break;
            }
            case 40: {
                this.record(3);
                break;
            }
            case 20: {
                this.record(4);
                break;
            }
            case 15: {
                this.record(5);
                break;
            }
            case 10: {
                this.record(6);
                break;
            }
            case 5: {
                this.record(7);
                break;
            }
            default: {
                this.record(0);
            }
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    private void record(int notification) {
        RecordHistogram.recordEnumeratedHistogram(this.mHistogramName, notification, 9);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface Notification {
        public static final int UNKNOWN_TRIM_LEVEL = 0;
        public static final int TRIM_MEMORY_COMPLETE = 1;
        public static final int TRIM_MEMORY_MODERATE = 2;
        public static final int TRIM_MEMORY_BACKGROUND = 3;
        public static final int TRIM_MEMORY_UI_HIDDEN = 4;
        public static final int TRIM_MEMORY_RUNNING_CRITICAL = 5;
        public static final int TRIM_MEMORY_RUNNING_LOW = 6;
        public static final int TRIM_MEMORY_RUNNING_MODERATE = 7;
        public static final int ON_LOW_MEMORY = 8;
        public static final int NUM_ENTRIES = 9;
    }
}

