/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.metrics;

import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class RecordUserAction {
    private static Throwable sDisabledBy;
    private static long sNativeActionCallback;

    @VisibleForTesting
    public static void setDisabledForTests(boolean disabled) {
        if (disabled && sDisabledBy != null) {
            throw new IllegalStateException("UserActions are already disabled.", sDisabledBy);
        }
        sDisabledBy = disabled ? new Throwable() : null;
    }

    public static void record(final String action) {
        if (sDisabledBy != null) {
            return;
        }
        if (ThreadUtils.runningOnUiThread()) {
            RecordUserAction.nativeRecordUserAction(action);
            return;
        }
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RecordUserAction.nativeRecordUserAction(action);
            }
        });
    }

    public static void setActionCallbackForTesting(UserActionCallback callback) {
        assert (sNativeActionCallback == 0L);
        sNativeActionCallback = RecordUserAction.nativeAddActionCallbackForTesting(callback);
    }

    public static void removeActionCallbackForTesting() {
        assert (sNativeActionCallback != 0L);
        RecordUserAction.nativeRemoveActionCallbackForTesting(sNativeActionCallback);
        sNativeActionCallback = 0L;
    }

    private static native void nativeRecordUserAction(String var0);

    private static native long nativeAddActionCallbackForTesting(UserActionCallback var0);

    private static native void nativeRemoveActionCallbackForTesting(long var0);

    public static interface UserActionCallback {
        @CalledByNative(value="UserActionCallback")
        public void onActionRecorded(String var1);
    }
}

