/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.os.Binder;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.DoNotInline;
import org.chromium.base.task.BackgroundOnlyAsyncTask;
import org.chromium.base.task.PostTask;
import org.chromium.base.task.SerialExecutor;
import org.chromium.base.task.TaskRunner;
import org.chromium.base.task.TaskTraits;

public abstract class AsyncTask<Result> {
    private static final String TAG = "AsyncTask";
    public static final Executor THREAD_POOL_EXECUTOR = r -> PostTask.postTask(TaskTraits.BEST_EFFORT_MAY_BLOCK, r);
    public static final Executor SERIAL_EXECUTOR = new SerialExecutor();
    private static final StealRunnableHandler STEAL_RUNNABLE_HANDLER = new StealRunnableHandler();
    private final Callable<Result> mWorker;
    private final FutureTask<Result> mFuture;
    private volatile int mStatus = 0;
    private final AtomicBoolean mCancelled = new AtomicBoolean();
    private final AtomicBoolean mTaskInvoked = new AtomicBoolean();

    public static void takeOverAndroidThreadPool() {
        ThreadPoolExecutor exec = (ThreadPoolExecutor)android.os.AsyncTask.THREAD_POOL_EXECUTOR;
        exec.setRejectedExecutionHandler(STEAL_RUNNABLE_HANDLER);
        exec.shutdown();
    }

    public AsyncTask() {
        this.mWorker = new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                AsyncTask.this.mTaskInvoked.set(true);
                Object result = null;
                try {
                    result = AsyncTask.this.doInBackground();
                    Binder.flushPendingCommands();
                }
                catch (Throwable tr) {
                    AsyncTask.this.mCancelled.set(true);
                    throw tr;
                }
                finally {
                    AsyncTask.this.postResult(result);
                }
                return result;
            }
        };
        this.mFuture = new NamedFutureTask(this.mWorker);
    }

    private void postResultIfNotInvoked(Result result) {
        boolean wasTaskInvoked = this.mTaskInvoked.get();
        if (!wasTaskInvoked) {
            this.postResult(result);
        }
    }

    private void postResult(Result result) {
        if (this instanceof BackgroundOnlyAsyncTask) {
            this.mStatus = 2;
        } else {
            ThreadUtils.postOnUiThread(() -> this.finish(result));
        }
    }

    public final int getStatus() {
        return this.mStatus;
    }

    @WorkerThread
    protected abstract Result doInBackground();

    @MainThread
    protected void onPreExecute() {
    }

    @MainThread
    protected abstract void onPostExecute(Result var1);

    @MainThread
    protected void onCancelled(Result result) {
        this.onCancelled();
    }

    @MainThread
    protected void onCancelled() {
    }

    public final boolean isCancelled() {
        return this.mCancelled.get();
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.mCancelled.set(true);
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    @DoNotInline
    public final Result get() throws InterruptedException, ExecutionException {
        Result r;
        if (this.getStatus() != 2 && ThreadUtils.runningOnUiThread()) {
            StackTraceElement[] stackTrace = new Exception().getStackTrace();
            String caller = "";
            if (stackTrace.length > 1) {
                caller = stackTrace[1].getClassName() + '.' + stackTrace[1].getMethodName() + '.';
            }
            try (TraceEvent e = TraceEvent.scoped(caller + "AsyncTask.get");){
                r = this.mFuture.get();
            }
        } else {
            r = this.mFuture.get();
        }
        return r;
    }

    private void executionPreamble() {
        if (this.mStatus != 0) {
            switch (this.mStatus) {
                case 1: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case 2: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
        }
        this.mStatus = 1;
        this.onPreExecute();
    }

    @MainThread
    public final AsyncTask<Result> executeOnExecutor(Executor exec) {
        this.executionPreamble();
        exec.execute(this.mFuture);
        return this;
    }

    @MainThread
    public final AsyncTask<Result> executeOnTaskRunner(TaskRunner taskRunner) {
        this.executionPreamble();
        taskRunner.postTask(this.mFuture);
        return this;
    }

    @MainThread
    public final AsyncTask<Result> executeWithTaskTraits(TaskTraits taskTraits) {
        this.executionPreamble();
        PostTask.postTask(taskTraits, this.mFuture);
        return this;
    }

    private void finish(Result result) {
        if (this.isCancelled()) {
            this.onCancelled(result);
        } else {
            this.onPostExecute(result);
        }
        this.mStatus = 2;
    }

    class NamedFutureTask
    extends FutureTask<Result> {
        NamedFutureTask(Callable<Result> c) {
            super(c);
        }

        Class getBlamedClass() {
            return AsyncTask.this.getClass();
        }

        @Override
        protected void done() {
            try {
                AsyncTask.this.postResultIfNotInvoked(this.get());
            }
            catch (InterruptedException e) {
                Log.w(AsyncTask.TAG, e.toString(), new Object[0]);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("An error occurred while executing doInBackground()", e.getCause());
            }
            catch (CancellationException e) {
                AsyncTask.this.postResultIfNotInvoked(null);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
        public static final int PENDING = 0;
        public static final int RUNNING = 1;
        public static final int FINISHED = 2;
    }

    private static class StealRunnableHandler
    implements RejectedExecutionHandler {
        private StealRunnableHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            THREAD_POOL_EXECUTOR.execute(r);
        }
    }
}

