/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.view.Choreographer;
import java.util.HashMap;
import java.util.Map;
import org.chromium.base.ThreadUtils;
import org.chromium.base.task.ChoreographerTaskRunner;
import org.chromium.base.task.SequencedTaskRunner;
import org.chromium.base.task.SequencedTaskRunnerImpl;
import org.chromium.base.task.SingleThreadTaskRunner;
import org.chromium.base.task.SingleThreadTaskRunnerImpl;
import org.chromium.base.task.TaskExecutor;
import org.chromium.base.task.TaskRunner;
import org.chromium.base.task.TaskRunnerImpl;
import org.chromium.base.task.TaskTraits;

class DefaultTaskExecutor
implements TaskExecutor {
    private final Map<TaskTraits, TaskRunner> mTraitsToRunnerMap = new HashMap<TaskTraits, TaskRunner>();
    private ChoreographerTaskRunner mChoreographerTaskRunner;

    DefaultTaskExecutor() {
    }

    @Override
    public TaskRunner createTaskRunner(TaskTraits taskTraits) {
        if (taskTraits.mIsChoreographerFrame) {
            return this.getChoreographerTaskRunner();
        }
        return new TaskRunnerImpl(taskTraits);
    }

    @Override
    public SequencedTaskRunner createSequencedTaskRunner(TaskTraits taskTraits) {
        if (taskTraits.mIsChoreographerFrame) {
            return this.getChoreographerTaskRunner();
        }
        return new SequencedTaskRunnerImpl(taskTraits);
    }

    @Override
    public SingleThreadTaskRunner createSingleThreadTaskRunner(TaskTraits taskTraits) {
        if (taskTraits.mIsChoreographerFrame) {
            return this.getChoreographerTaskRunner();
        }
        return new SingleThreadTaskRunnerImpl(null, taskTraits);
    }

    @Override
    public synchronized void postDelayedTask(TaskTraits taskTraits, Runnable task, long delay) {
        if (taskTraits.hasExtension()) {
            TaskRunner runner = this.createTaskRunner(taskTraits);
            runner.postDelayedTask(task, delay);
            runner.destroy();
        } else {
            TaskRunner runner = this.mTraitsToRunnerMap.get(taskTraits);
            if (runner == null) {
                TaskRunnerImpl runnerImpl = new TaskRunnerImpl(taskTraits);
                runnerImpl.disableLifetimeCheck();
                this.mTraitsToRunnerMap.put(taskTraits, runnerImpl);
                runner = runnerImpl;
            }
            runner.postDelayedTask(task, delay);
        }
    }

    @Override
    public boolean canRunTaskImmediately(TaskTraits traits) {
        return false;
    }

    private synchronized ChoreographerTaskRunner getChoreographerTaskRunner() {
        ChoreographerTaskRunner choreographerTaskRunner = ThreadUtils.runOnUiThreadBlockingNoException(() -> new ChoreographerTaskRunner(Choreographer.getInstance()));
        this.mTraitsToRunnerMap.put(TaskTraits.CHOREOGRAPHER_FRAME, choreographerTaskRunner);
        return choreographerTaskRunner;
    }
}

