/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.ChromeThreadPoolExecutor;
import org.chromium.base.task.DefaultTaskExecutor;
import org.chromium.base.task.SequencedTaskRunner;
import org.chromium.base.task.SingleThreadTaskRunner;
import org.chromium.base.task.TaskExecutor;
import org.chromium.base.task.TaskRunner;
import org.chromium.base.task.TaskTraits;

@JNINamespace(value="base")
public class PostTask {
    private static final Object sLock = new Object();
    private static Set<TaskRunner> sPreNativeTaskRunners = Collections.newSetFromMap(new WeakHashMap());
    private static final Executor sPrenativeThreadPoolExecutor = new ChromeThreadPoolExecutor();
    private static Executor sPrenativeThreadPoolExecutorOverride;
    private static final TaskExecutor[] sTaskExecutors;

    private static TaskExecutor[] getInitialTaskExecutors() {
        TaskExecutor[] taskExecutors = new TaskExecutor[5];
        taskExecutors[0] = new DefaultTaskExecutor();
        return taskExecutors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskRunner createTaskRunner(TaskTraits taskTraits) {
        Object object = sLock;
        synchronized (object) {
            return PostTask.getTaskExecutorForTraits(taskTraits).createTaskRunner(taskTraits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SequencedTaskRunner createSequencedTaskRunner(TaskTraits taskTraits) {
        Object object = sLock;
        synchronized (object) {
            return PostTask.getTaskExecutorForTraits(taskTraits).createSequencedTaskRunner(taskTraits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SingleThreadTaskRunner createSingleThreadTaskRunner(TaskTraits taskTraits) {
        Object object = sLock;
        synchronized (object) {
            return PostTask.getTaskExecutorForTraits(taskTraits).createSingleThreadTaskRunner(taskTraits);
        }
    }

    public static void postTask(TaskTraits taskTraits, Runnable task) {
        PostTask.postDelayedTask(taskTraits, task, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void postDelayedTask(TaskTraits taskTraits, Runnable task, long delay) {
        Object object = sLock;
        synchronized (object) {
            if (sPreNativeTaskRunners != null) {
                PostTask.getTaskExecutorForTraits(taskTraits).postDelayedTask(taskTraits, task, delay);
            } else {
                PostTask.nativePostDelayedTask(taskTraits.mPrioritySetExplicitly, taskTraits.mPriority, taskTraits.mMayBlock, taskTraits.mUseThreadPool, taskTraits.mExtensionId, taskTraits.mExtensionData, task, delay);
            }
        }
    }

    public static void runOrPostTask(TaskTraits taskTraits, Runnable task) {
        if (PostTask.getTaskExecutorForTraits(taskTraits).canRunTaskImmediately(taskTraits)) {
            task.run();
        } else {
            PostTask.postTask(taskTraits, task);
        }
    }

    @Deprecated
    public static <T> T runSynchronously(TaskTraits taskTraits, Callable<T> c) {
        return PostTask.runSynchronouslyInternal(taskTraits, new FutureTask<T>(c));
    }

    @Deprecated
    public static void runSynchronously(TaskTraits taskTraits, Runnable r) {
        PostTask.runSynchronouslyInternal(taskTraits, new FutureTask<Object>(r, null));
    }

    private static <T> T runSynchronouslyInternal(TaskTraits taskTraits, FutureTask<T> task) {
        PostTask.runOrPostTask(taskTraits, task);
        try {
            return task.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTaskExecutor(int extensionId, TaskExecutor taskExecutor) {
        Object object = sLock;
        synchronized (object) {
            assert (extensionId != 0);
            assert (extensionId <= 4);
            assert (sTaskExecutors[extensionId] == null);
            PostTask.sTaskExecutors[extensionId] = taskExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPrenativeThreadPoolExecutorForTesting(Executor executor) {
        Object object = sLock;
        synchronized (object) {
            sPrenativeThreadPoolExecutorOverride = executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPrenativeThreadPoolExecutorForTesting() {
        Object object = sLock;
        synchronized (object) {
            sPrenativeThreadPoolExecutorOverride = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Executor getPrenativeThreadPoolExecutor() {
        Object object = sLock;
        synchronized (object) {
            if (sPrenativeThreadPoolExecutorOverride != null) {
                return sPrenativeThreadPoolExecutorOverride;
            }
            return sPrenativeThreadPoolExecutor;
        }
    }

    static boolean registerPreNativeTaskRunnerLocked(TaskRunner taskRunner) {
        if (sPreNativeTaskRunners != null) {
            sPreNativeTaskRunners.add(taskRunner);
            return true;
        }
        return false;
    }

    private static TaskExecutor getTaskExecutorForTraits(TaskTraits traits) {
        return sTaskExecutors[traits.mExtensionId];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private static void onNativeSchedulerReady() {
        Object object = sLock;
        synchronized (object) {
            for (TaskRunner taskRunner : sPreNativeTaskRunners) {
                taskRunner.initNativeTaskRunner();
            }
            sPreNativeTaskRunners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private static void onNativeSchedulerShutdown() {
        Object object = sLock;
        synchronized (object) {
            sPreNativeTaskRunners = Collections.newSetFromMap(new WeakHashMap());
        }
    }

    private static native void nativePostDelayedTask(boolean var0, int var1, boolean var2, boolean var3, byte var4, byte[] var5, Runnable var6, long var7);

    static {
        sTaskExecutors = PostTask.getInitialTaskExecutors();
    }
}

