/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.task.SequencedTaskRunner;
import org.chromium.base.task.TaskRunnerImpl;
import org.chromium.base.task.TaskTraits;

public class SequencedTaskRunnerImpl
extends TaskRunnerImpl
implements SequencedTaskRunner {
    private AtomicInteger mPendingTasks = new AtomicInteger();
    @GuardedBy(value="mLock")
    private int mNumUnfinishedNativeTasks;

    SequencedTaskRunnerImpl(TaskTraits traits) {
        super(traits, "SequencedTaskRunnerImpl", 1);
        this.disableLifetimeCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initNativeTaskRunner() {
        Object object = this.mLock;
        synchronized (object) {
            this.migratePreNativeTasksToNative();
        }
    }

    @Override
    protected void schedulePreNativeTask() {
        if (this.mPendingTasks.getAndIncrement() == 0) {
            super.schedulePreNativeTask();
        }
    }

    @Override
    protected void runPreNativeTask() {
        super.runPreNativeTask();
        if (this.mPendingTasks.decrementAndGet() > 0) {
            super.schedulePreNativeTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postDelayedTaskToNative(Runnable runnable, long delay) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNumUnfinishedNativeTasks++ == 0) {
                this.initNativeTaskRunnerInternal();
            }
            Runnable r = () -> {
                runnable.run();
                Object object = this.mLock;
                synchronized (object) {
                    if (--this.mNumUnfinishedNativeTasks == 0) {
                        this.destroyInternal();
                    }
                }
            };
            super.postDelayedTaskToNative(r, delay);
        }
    }
}

