/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.SingleThreadTaskRunner;
import org.chromium.base.task.TaskRunnerImpl;
import org.chromium.base.task.TaskTraits;

@JNINamespace(value="base")
public class SingleThreadTaskRunnerImpl
extends TaskRunnerImpl
implements SingleThreadTaskRunner {
    @Nullable
    private final Handler mHandler;
    private final boolean mPostTaskAtFrontOfQueue;

    public SingleThreadTaskRunnerImpl(Handler handler, TaskTraits traits, boolean postTaskAtFrontOfQueue) {
        super(traits, "SingleThreadTaskRunnerImpl", 2);
        this.mHandler = handler;
        this.mPostTaskAtFrontOfQueue = postTaskAtFrontOfQueue;
    }

    public SingleThreadTaskRunnerImpl(Handler handler, TaskTraits traits) {
        this(handler, traits, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean belongsToCurrentThread() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNativeTaskRunnerAndroid != 0L) {
                return this.nativeBelongsToCurrentThread(this.mNativeTaskRunnerAndroid);
            }
        }
        if (this.mHandler != null) {
            return this.mHandler.getLooper().getThread() == Thread.currentThread();
        }
        assert (false);
        return false;
    }

    @Override
    protected void schedulePreNativeTask() {
        if (this.mHandler == null) {
            return;
        }
        if (this.mPostTaskAtFrontOfQueue) {
            this.postAtFrontOfQueue();
        } else {
            this.mHandler.post(this.mRunPreNativeTaskClosure);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void postAtFrontOfQueue() {
        if (Build.VERSION.SDK_INT >= 21) {
            Message message = Message.obtain((Handler)this.mHandler, (Runnable)this.mRunPreNativeTaskClosure);
            message.setAsynchronous(true);
            this.mHandler.sendMessageAtFrontOfQueue(message);
        } else {
            this.mHandler.postAtFrontOfQueue(this.mRunPreNativeTaskClosure);
        }
    }
}

