/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import android.os.Process;
import android.support.annotation.Nullable;
import android.util.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.LifetimeAssert;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.PostTask;
import org.chromium.base.task.TaskRunner;
import org.chromium.base.task.TaskTraits;

@JNINamespace(value="base")
public class TaskRunnerImpl
implements TaskRunner {
    private final TaskTraits mTaskTraits;
    private final String mTraceEvent;
    private final int mTaskRunnerType;
    protected final Object mLock = new Object();
    @GuardedBy(value="mLock")
    protected long mNativeTaskRunnerAndroid;
    protected final Runnable mRunPreNativeTaskClosure = this::runPreNativeTask;
    @GuardedBy(value="mLock")
    private boolean mIsDestroying;
    private final LifetimeAssert mLifetimeAssert = LifetimeAssert.create(this);
    @Nullable
    protected LinkedList<Runnable> mPreNativeTasks = new LinkedList();
    @Nullable
    protected List<Pair<Runnable, Long>> mPreNativeDelayedTasks = new ArrayList<Pair<Runnable, Long>>();

    TaskRunnerImpl(TaskTraits traits) {
        this(traits, "TaskRunnerImpl", 0);
    }

    protected TaskRunnerImpl(TaskTraits traits, String traceCategory, int taskRunnerType) {
        this.mTaskTraits = traits;
        this.mTraceEvent = traceCategory + ".PreNativeTask.run";
        this.mTaskRunnerType = taskRunnerType;
        if (!PostTask.registerPreNativeTaskRunnerLocked(this)) {
            this.initNativeTaskRunner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            LifetimeAssert.setSafeToGc(this.mLifetimeAssert, true);
            this.mIsDestroying = true;
            this.destroyInternal();
        }
    }

    @GuardedBy(value="mLock")
    protected void destroyInternal() {
        if (this.mNativeTaskRunnerAndroid != 0L) {
            this.nativeDestroy(this.mNativeTaskRunnerAndroid);
        }
        this.mNativeTaskRunnerAndroid = 0L;
    }

    @Override
    public void disableLifetimeCheck() {
        LifetimeAssert.setSafeToGc(this.mLifetimeAssert, true);
    }

    @Override
    public void postTask(Runnable task) {
        this.postDelayedTask(task, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postDelayedTask(Runnable task, long delay) {
        Object object = this.mLock;
        synchronized (object) {
            assert (!this.mIsDestroying);
            if (this.mPreNativeTasks == null) {
                this.postDelayedTaskToNative(task, delay);
                return;
            }
            if (delay == 0L) {
                this.mPreNativeTasks.add(task);
                this.schedulePreNativeTask();
            } else {
                Pair preNativeDelayedTask = new Pair((Object)task, (Object)delay);
                this.mPreNativeDelayedTasks.add((Pair<Runnable, Long>)preNativeDelayedTask);
            }
        }
    }

    protected void schedulePreNativeTask() {
        PostTask.getPrenativeThreadPoolExecutor().execute(this.mRunPreNativeTaskClosure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPreNativeTask() {
        try (TraceEvent te = TraceEvent.scoped(this.mTraceEvent);){
            Runnable task;
            Object object = this.mLock;
            synchronized (object) {
                block23: {
                    if (this.mPreNativeTasks != null) break block23;
                    return;
                }
                task = this.mPreNativeTasks.poll();
            }
            switch (this.mTaskTraits.mPriority) {
                case 1: {
                    Process.setThreadPriority((int)0);
                    break;
                }
                case 2: {
                    Process.setThreadPriority((int)-1);
                    break;
                }
                default: {
                    Process.setThreadPriority((int)10);
                }
            }
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initNativeTaskRunner() {
        Object object = this.mLock;
        synchronized (object) {
            this.initNativeTaskRunnerInternal();
            this.migratePreNativeTasksToNative();
        }
    }

    @GuardedBy(value="mLock")
    protected void initNativeTaskRunnerInternal() {
        if (this.mNativeTaskRunnerAndroid == 0L) {
            this.mNativeTaskRunnerAndroid = this.nativeInit(this.mTaskRunnerType, this.mTaskTraits.mPrioritySetExplicitly, this.mTaskTraits.mPriority, this.mTaskTraits.mMayBlock, this.mTaskTraits.mUseThreadPool, this.mTaskTraits.mExtensionId, this.mTaskTraits.mExtensionData);
        }
    }

    @GuardedBy(value="mLock")
    protected void migratePreNativeTasksToNative() {
        if (this.mPreNativeTasks != null) {
            for (Runnable runnable : this.mPreNativeTasks) {
                this.postDelayedTaskToNative(runnable, 0L);
            }
            for (Pair pair : this.mPreNativeDelayedTasks) {
                this.postDelayedTaskToNative((Runnable)pair.first, (Long)pair.second);
            }
            this.mPreNativeTasks = null;
            this.mPreNativeDelayedTasks = null;
        }
    }

    @GuardedBy(value="mLock")
    protected void postDelayedTaskToNative(Runnable r, long delay) {
        this.nativePostDelayedTask(this.mNativeTaskRunnerAndroid, r, delay);
    }

    private native long nativeInit(int var1, boolean var2, int var3, boolean var4, boolean var5, byte var6, byte[] var7);

    private native void nativeDestroy(long var1);

    private native void nativePostDelayedTask(long var1, Runnable var3, long var4);

    protected native boolean nativeBelongsToCurrentThread(long var1);
}

