/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net::android")
public class AndroidCellularSignalStrength {
    private volatile int mSignalLevel = Integer.MIN_VALUE;
    private static final AndroidCellularSignalStrength sInstance = new AndroidCellularSignalStrength();

    private AndroidCellularSignalStrength() {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        HandlerThread handlerThread = new HandlerThread("AndroidCellularSignalStrength");
        handlerThread.start();
        new Handler(handlerThread.getLooper()).post(new Runnable(){

            @Override
            public void run() {
                new CellStateListener();
            }
        });
    }

    @TargetApi(value=23)
    @CalledByNative
    private static int getSignalStrengthLevel() {
        return AndroidCellularSignalStrength.sInstance.mSignalLevel;
    }

    private class CellStateListener
    extends PhoneStateListener
    implements ApplicationStatus.ApplicationStateListener {
        private final TelephonyManager mTelephonyManager;

        CellStateListener() {
            ThreadUtils.assertOnBackgroundThread();
            this.mTelephonyManager = (TelephonyManager)ContextUtils.getApplicationContext().getSystemService("phone");
            if (this.mTelephonyManager.getSimState() != 5) {
                return;
            }
            ApplicationStatus.registerApplicationStateListener(this);
            this.onApplicationStateChange(ApplicationStatus.getStateForApplication());
        }

        private void register() {
            this.mTelephonyManager.listen((PhoneStateListener)this, 256);
        }

        private void unregister() {
            AndroidCellularSignalStrength.this.mSignalLevel = Integer.MIN_VALUE;
            this.mTelephonyManager.listen((PhoneStateListener)this, 0);
        }

        @TargetApi(value=23)
        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            block3: {
                if (ApplicationStatus.getStateForApplication() != 1) {
                    return;
                }
                try {
                    AndroidCellularSignalStrength.this.mSignalLevel = signalStrength.getLevel();
                }
                catch (SecurityException e) {
                    AndroidCellularSignalStrength.this.mSignalLevel = Integer.MIN_VALUE;
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }

        @Override
        public void onApplicationStateChange(int newState) {
            if (newState == 1) {
                this.register();
            } else if (newState == 2) {
                this.unregister();
            }
        }
    }
}

