/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.TargetApi;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.security.NetworkSecurityPolicy;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.ContextUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.CalledByNativeUnchecked;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.compat.ApiHelperForM;
import org.chromium.base.compat.ApiHelperForP;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.net.AndroidCertVerifyResult;
import org.chromium.net.AndroidTelephonyManagerBridge;
import org.chromium.net.ThreadStatsUid;
import org.chromium.net.X509Util;

@MainDex
class AndroidNetworkLibrary {
    private static final String TAG = "AndroidNetworkLibrary";
    private static Boolean sHaveAccessNetworkState;
    private static Boolean sHaveAccessWifiState;
    private static final Set<InetAddress> sAutoDohServers;
    private static final Set<String> sAutoDohDotServers;

    AndroidNetworkLibrary() {
    }

    @CalledByNative
    public static String getMimeTypeFromExtension(String extension) {
        return URLConnection.guessContentTypeFromName("foo." + extension);
    }

    @CalledByNative
    public static boolean haveOnlyLoopbackAddresses() {
        Enumeration<NetworkInterface> list = null;
        try {
            list = NetworkInterface.getNetworkInterfaces();
            if (list == null) {
                return false;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("could not get network interfaces: " + e));
            return false;
        }
        while (list.hasMoreElements()) {
            NetworkInterface netIf = list.nextElement();
            try {
                if (!netIf.isUp() || netIf.isLoopback()) continue;
                return false;
            }
            catch (SocketException e) {
            }
        }
        return true;
    }

    @CalledByNative
    public static AndroidCertVerifyResult verifyServerCertificates(byte[][] certChain, String authType, String host) {
        try {
            return X509Util.verifyServerCertificates(certChain, authType, host);
        }
        catch (KeyStoreException e) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (NoSuchAlgorithmException e) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (IllegalArgumentException e) {
            return new AndroidCertVerifyResult(-1);
        }
    }

    @CalledByNativeUnchecked
    public static void addTestRootCertificate(byte[] rootCert) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Util.addTestRootCertificate(rootCert);
    }

    @CalledByNativeUnchecked
    public static void clearTestRootCertificates() throws NoSuchAlgorithmException, CertificateException, KeyStoreException {
        X509Util.clearTestRootCertificates();
    }

    @CalledByNative
    private static String getNetworkCountryIso() {
        return AndroidTelephonyManagerBridge.getInstance().getNetworkCountryIso();
    }

    @CalledByNative
    private static String getNetworkOperator() {
        return AndroidTelephonyManagerBridge.getInstance().getNetworkOperator();
    }

    @CalledByNative
    private static String getSimOperator() {
        return AndroidTelephonyManagerBridge.getInstance().getSimOperator();
    }

    @CalledByNative
    private static boolean getIsRoaming() {
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        return networkInfo.isRoaming();
    }

    @TargetApi(value=23)
    @CalledByNative
    private static boolean getIsCaptivePortal() {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        Network network = ApiHelperForM.getActiveNetwork(connectivityManager);
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasCapability(17);
    }

    @CalledByNative
    public static String getWifiSSID() {
        String ssid;
        WifiInfo wifiInfo = null;
        if (AndroidNetworkLibrary.haveAccessWifiState()) {
            WifiManager wifiManager = (WifiManager)ContextUtils.getApplicationContext().getSystemService("wifi");
            wifiInfo = wifiManager.getConnectionInfo();
        } else {
            Intent intent = ContextUtils.getApplicationContext().registerReceiver(null, new IntentFilter("android.net.wifi.STATE_CHANGE"));
            if (intent != null) {
                wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo");
            }
        }
        if (wifiInfo != null && (ssid = wifiInfo.getSSID()) != null && !ssid.equals("<unknown ssid>")) {
            return ssid;
        }
        return "";
    }

    @CalledByNative
    public static int getWifiSignalLevel(int countBuckets) {
        Intent intent = null;
        try {
            intent = ContextUtils.getApplicationContext().registerReceiver(null, new IntentFilter("android.net.wifi.RSSI_CHANGED"));
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
        if (intent == null) {
            return -1;
        }
        int rssi = intent.getIntExtra("newRssi", Integer.MIN_VALUE);
        if (rssi == Integer.MIN_VALUE) {
            return -1;
        }
        int signalLevel = WifiManager.calculateSignalLevel((int)rssi, (int)countBuckets);
        if (signalLevel < 0 || signalLevel >= countBuckets) {
            return -1;
        }
        return signalLevel;
    }

    @CalledByNative
    private static boolean isCleartextPermitted(String host) {
        try {
            return NetworkSecurityPolicyProxy.getInstance().isCleartextTrafficPermitted(host);
        }
        catch (IllegalArgumentException e) {
            return NetworkSecurityPolicyProxy.getInstance().isCleartextTrafficPermitted();
        }
    }

    static boolean isPrivateDnsActive(LinkProperties linkProperties) {
        if (Build.VERSION.SDK_INT >= 28 && linkProperties != null) {
            return ApiHelperForP.isPrivateDnsActive(linkProperties);
        }
        return false;
    }

    private static String getPrivateDnsServerName(LinkProperties linkProperties) {
        if (Build.VERSION.SDK_INT >= 28 && linkProperties != null) {
            return ApiHelperForP.getPrivateDnsServerName(linkProperties);
        }
        return null;
    }

    private static boolean haveAccessNetworkState() {
        if (sHaveAccessNetworkState == null) {
            sHaveAccessNetworkState = ApiCompatibilityUtils.checkPermission(ContextUtils.getApplicationContext(), "android.permission.ACCESS_NETWORK_STATE", Process.myPid(), Process.myUid()) == 0;
        }
        return sHaveAccessNetworkState;
    }

    private static boolean haveAccessWifiState() {
        if (sHaveAccessWifiState == null) {
            sHaveAccessWifiState = ApiCompatibilityUtils.checkPermission(ContextUtils.getApplicationContext(), "android.permission.ACCESS_WIFI_STATE", Process.myPid(), Process.myUid()) == 0;
        }
        return sHaveAccessWifiState;
    }

    @TargetApi(value=23)
    @CalledByNative
    private static byte[][] getDnsServers() {
        if (!AndroidNetworkLibrary.haveAccessNetworkState()) {
            return new byte[0][0];
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
        if (connectivityManager == null) {
            return new byte[0][0];
        }
        Network network = ApiHelperForM.getActiveNetwork(connectivityManager);
        if (network == null) {
            return new byte[0][0];
        }
        LinkProperties linkProperties = connectivityManager.getLinkProperties(network);
        if (linkProperties == null) {
            return new byte[0][0];
        }
        List dnsServersList = linkProperties.getDnsServers();
        boolean autoDoh = false;
        for (InetAddress dnsServer : dnsServersList) {
            if (!sAutoDohServers.contains(dnsServer)) continue;
            autoDoh = true;
            break;
        }
        if (AndroidNetworkLibrary.isPrivateDnsActive(linkProperties)) {
            String privateDnsServerName = AndroidNetworkLibrary.getPrivateDnsServerName(linkProperties);
            if (privateDnsServerName != null) {
                autoDoh = sAutoDohDotServers.contains(privateDnsServerName.toLowerCase(Locale.US));
            }
            RecordHistogram.recordBooleanHistogram("Net.DNS.Android.DotExplicit", privateDnsServerName != null);
            RecordHistogram.recordBooleanHistogram("Net.DNS.Android.AutoDohPrivate", autoDoh);
            return new byte[1][1];
        }
        RecordHistogram.recordBooleanHistogram("Net.DNS.Android.AutoDohPublic", autoDoh);
        byte[][] dnsServers = new byte[dnsServersList.size()][];
        for (int i = 0; i < dnsServersList.size(); ++i) {
            dnsServers[i] = ((InetAddress)dnsServersList.get(i)).getAddress();
        }
        return dnsServers;
    }

    @CalledByNative
    private static void tagSocket(int ifd, int uid, int tag) throws IOException {
        FileDescriptor fd;
        ParcelFileDescriptor pfd;
        int oldTag = TrafficStats.getThreadStatsTag();
        if (tag != oldTag) {
            TrafficStats.setThreadStatsTag((int)tag);
        }
        if (uid != -1) {
            ThreadStatsUid.set((int)uid);
        }
        if (Build.VERSION.SDK_INT < 23) {
            pfd = null;
            fd = SetFileDescriptor.createWithFd(ifd);
        } else {
            pfd = ParcelFileDescriptor.adoptFd((int)ifd);
            fd = pfd.getFileDescriptor();
        }
        SocketFd s = new SocketFd(fd);
        TrafficStats.tagSocket((Socket)s);
        s.close();
        if (pfd != null) {
            pfd.detachFd();
        }
        if (tag != oldTag) {
            TrafficStats.setThreadStatsTag((int)oldTag);
        }
        if (uid != -1) {
            ThreadStatsUid.clear();
        }
    }

    static {
        sAutoDohServers = new HashSet<InetAddress>();
        sAutoDohDotServers = new HashSet<String>();
        try {
            sAutoDohServers.add(InetAddress.getByName("8.8.8.8"));
            sAutoDohServers.add(InetAddress.getByName("8.8.4.4"));
            sAutoDohServers.add(InetAddress.getByName("2001:4860:4860::8888"));
            sAutoDohServers.add(InetAddress.getByName("2001:4860:4860::8844"));
            sAutoDohServers.add(InetAddress.getByName("1.1.1.1"));
            sAutoDohServers.add(InetAddress.getByName("1.0.0.1"));
            sAutoDohServers.add(InetAddress.getByName("2606:4700:4700::1111"));
            sAutoDohServers.add(InetAddress.getByName("2606:4700:4700::1001"));
            sAutoDohServers.add(InetAddress.getByName("9.9.9.9"));
            sAutoDohServers.add(InetAddress.getByName("149.112.112.112"));
            sAutoDohServers.add(InetAddress.getByName("2620:fe::fe"));
            sAutoDohServers.add(InetAddress.getByName("2620:fe::9"));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to parse IP addresses", e);
        }
        sAutoDohDotServers.add("dns.google");
        sAutoDohDotServers.add("1dot1dot1dot1.cloudflare-dns.com");
        sAutoDohDotServers.add("cloudflare-dns.com");
        sAutoDohDotServers.add("dns.quad9.net");
    }

    private static class SocketFd
    extends Socket {
        SocketFd(FileDescriptor fd) throws IOException {
            super(new SocketImplFd(fd));
        }

        private static class SocketImplFd
        extends SocketImpl {
            SocketImplFd(FileDescriptor fd) {
                this.fd = fd;
            }

            @Override
            protected void accept(SocketImpl s) {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            protected int available() {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            protected void bind(InetAddress host, int port) {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            protected void close() {
            }

            @Override
            protected void connect(InetAddress address, int port) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            protected void connect(SocketAddress address, int timeout) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            protected void connect(String host, int port) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            protected void create(boolean stream) {
            }

            @Override
            protected InputStream getInputStream() {
                throw new RuntimeException("getInputStream not implemented");
            }

            @Override
            protected OutputStream getOutputStream() {
                throw new RuntimeException("getOutputStream not implemented");
            }

            @Override
            protected void listen(int backlog) {
                throw new RuntimeException("listen not implemented");
            }

            @Override
            protected void sendUrgentData(int data) {
                throw new RuntimeException("sendUrgentData not implemented");
            }

            @Override
            public Object getOption(int optID) {
                throw new RuntimeException("getOption not implemented");
            }

            @Override
            public void setOption(int optID, Object value) {
                throw new RuntimeException("setOption not implemented");
            }
        }
    }

    private static class SetFileDescriptor {
        private static final Method sFileDescriptorSetInt;

        private SetFileDescriptor() {
        }

        public static FileDescriptor createWithFd(int fd) {
            try {
                FileDescriptor fileDescriptor = new FileDescriptor();
                sFileDescriptorSetInt.invoke((Object)fileDescriptor, fd);
                return fileDescriptor;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("FileDescriptor.setInt$() failed", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("FileDescriptor.setInt$() failed", e);
            }
        }

        static {
            try {
                sFileDescriptorSetInt = FileDescriptor.class.getMethod("setInt$", Integer.TYPE);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException("Unable to get FileDescriptor.setInt$", e);
            }
        }
    }

    public static class NetworkSecurityPolicyProxy {
        private static NetworkSecurityPolicyProxy sInstance = new NetworkSecurityPolicyProxy();

        public static NetworkSecurityPolicyProxy getInstance() {
            return sInstance;
        }

        @VisibleForTesting
        public static void setInstanceForTesting(NetworkSecurityPolicyProxy networkSecurityPolicyProxy) {
            sInstance = networkSecurityPolicyProxy;
        }

        @TargetApi(value=24)
        public boolean isCleartextTrafficPermitted(String host) {
            if (Build.VERSION.SDK_INT < 24) {
                return this.isCleartextTrafficPermitted();
            }
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(host);
        }

        @TargetApi(value=23)
        public boolean isCleartextTrafficPermitted() {
            if (Build.VERSION.SDK_INT < 23) {
                return true;
            }
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
        }
    }
}

