/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import javax.annotation.CheckForNull;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.MainDex;

@AnyThread
@MainDex
public class AndroidTelephonyManagerBridge {
    private static volatile AndroidTelephonyManagerBridge sInstance;
    @CheckForNull
    private volatile String mNetworkCountryIso;
    @CheckForNull
    private volatile String mNetworkOperator;
    @CheckForNull
    private volatile String mSimOperator;
    private Listener mListener;

    private AndroidTelephonyManagerBridge() {
    }

    public String getNetworkCountryIso() {
        if (this.mNetworkCountryIso == null) {
            TelephonyManager telephonyManager = AndroidTelephonyManagerBridge.getTelephonyManager();
            if (telephonyManager == null) {
                return "";
            }
            this.mNetworkCountryIso = telephonyManager.getNetworkCountryIso();
        }
        return this.mNetworkCountryIso;
    }

    public String getNetworkOperator() {
        if (this.mNetworkOperator == null) {
            TelephonyManager telephonyManager = AndroidTelephonyManagerBridge.getTelephonyManager();
            if (telephonyManager == null) {
                return "";
            }
            this.mNetworkOperator = telephonyManager.getNetworkOperator();
        }
        return this.mNetworkOperator;
    }

    public String getSimOperator() {
        if (this.mSimOperator == null) {
            TelephonyManager telephonyManager = AndroidTelephonyManagerBridge.getTelephonyManager();
            if (telephonyManager == null) {
                return "";
            }
            this.mSimOperator = telephonyManager.getSimOperator();
        }
        return this.mSimOperator;
    }

    private void update(@CheckForNull TelephonyManager telephonyManager) {
        if (telephonyManager == null) {
            return;
        }
        this.mNetworkCountryIso = telephonyManager.getNetworkCountryIso();
        this.mNetworkOperator = telephonyManager.getNetworkOperator();
        this.mSimOperator = telephonyManager.getSimOperator();
    }

    @MainThread
    private void listenTelephonyServiceState(TelephonyManager telephonyManager) {
        ThreadUtils.assertOnUiThread();
        this.mListener = new Listener();
        telephonyManager.listen((PhoneStateListener)this.mListener, 1);
    }

    @CheckForNull
    private static TelephonyManager getTelephonyManager() {
        return (TelephonyManager)ContextUtils.getApplicationContext().getSystemService("phone");
    }

    private static AndroidTelephonyManagerBridge create() {
        AndroidTelephonyManagerBridge instance = new AndroidTelephonyManagerBridge();
        ThreadUtils.runOnUiThread(() -> {
            TelephonyManager telephonyManager = AndroidTelephonyManagerBridge.getTelephonyManager();
            if (telephonyManager != null) {
                instance.listenTelephonyServiceState(telephonyManager);
            }
        });
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AndroidTelephonyManagerBridge getInstance() {
        AndroidTelephonyManagerBridge instance = sInstance;
        if (instance != null) return instance;
        Class<AndroidTelephonyManagerBridge> clazz = AndroidTelephonyManagerBridge.class;
        synchronized (AndroidTelephonyManagerBridge.class) {
            instance = sInstance;
            if (instance != null) return instance;
            sInstance = instance = AndroidTelephonyManagerBridge.create();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private class Listener
    extends PhoneStateListener {
        @CheckForNull
        private ServiceState mServiceState;

        private Listener() {
        }

        public void onServiceStateChanged(ServiceState serviceState) {
            if (this.mServiceState == null || !this.mServiceState.equals((Object)serviceState)) {
                this.mServiceState = serviceState;
                AndroidTelephonyManagerBridge.this.update(AndroidTelephonyManagerBridge.getTelephonyManager());
            }
        }
    }
}

