/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.SuppressLint;
import android.net.ConnectivityManager;
import android.os.Build;
import java.util.ArrayList;
import org.chromium.base.ContextUtils;
import org.chromium.base.ObserverList;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.NativeClassQualifiedName;
import org.chromium.base.compat.ApiHelperForM;
import org.chromium.net.NetworkChangeNotifierAutoDetect;
import org.chromium.net.RegistrationPolicyAlwaysRegister;
import org.chromium.net.RegistrationPolicyApplicationStatus;

@JNINamespace(value="net")
public class NetworkChangeNotifier {
    private final ArrayList<Long> mNativeChangeNotifiers = new ArrayList();
    private final ObserverList<ConnectionTypeObserver> mConnectionTypeObservers = new ObserverList();
    private final ConnectivityManager mConnectivityManager = (ConnectivityManager)ContextUtils.getApplicationContext().getSystemService("connectivity");
    private NetworkChangeNotifierAutoDetect mAutoDetector;
    private int mCurrentConnectionType = 0;
    @SuppressLint(value={"StaticFieldLeak"})
    private static NetworkChangeNotifier sInstance;

    @VisibleForTesting
    protected NetworkChangeNotifier() {
    }

    @CalledByNative
    public static NetworkChangeNotifier init() {
        if (sInstance == null) {
            sInstance = new NetworkChangeNotifier();
        }
        return sInstance;
    }

    public static boolean isInitialized() {
        return sInstance != null;
    }

    static void resetInstanceForTests(NetworkChangeNotifier notifier) {
        sInstance = notifier;
    }

    @CalledByNative
    public int getCurrentConnectionType() {
        return this.mCurrentConnectionType;
    }

    @CalledByNative
    public int getCurrentConnectionSubtype() {
        return this.mAutoDetector == null ? 0 : this.mAutoDetector.getCurrentNetworkState().getConnectionSubtype();
    }

    @CalledByNative
    public long getCurrentDefaultNetId() {
        return this.mAutoDetector == null ? -1L : this.mAutoDetector.getDefaultNetId();
    }

    @CalledByNative
    public long[] getCurrentNetworksAndTypes() {
        return this.mAutoDetector == null ? new long[]{} : this.mAutoDetector.getNetworksAndTypes();
    }

    @CalledByNative
    public void addNativeObserver(long nativeChangeNotifier) {
        this.mNativeChangeNotifiers.add(nativeChangeNotifier);
    }

    @CalledByNative
    public void removeNativeObserver(long nativeChangeNotifier) {
        this.mNativeChangeNotifiers.remove(nativeChangeNotifier);
    }

    @CalledByNative
    public boolean registerNetworkCallbackFailed() {
        return this.mAutoDetector == null ? false : this.mAutoDetector.registerNetworkCallbackFailed();
    }

    public static NetworkChangeNotifier getInstance() {
        assert (sInstance != null);
        return sInstance;
    }

    public static void setAutoDetectConnectivityState(boolean shouldAutoDetect) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(shouldAutoDetect, new RegistrationPolicyApplicationStatus());
    }

    public static void registerToReceiveNotificationsAlways() {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(true, new RegistrationPolicyAlwaysRegister());
    }

    public static void setAutoDetectConnectivityState(NetworkChangeNotifierAutoDetect.RegistrationPolicy policy) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(true, policy);
    }

    private void destroyAutoDetector() {
        if (this.mAutoDetector != null) {
            this.mAutoDetector.destroy();
            this.mAutoDetector = null;
        }
    }

    private void setAutoDetectConnectivityStateInternal(boolean shouldAutoDetect, NetworkChangeNotifierAutoDetect.RegistrationPolicy policy) {
        if (shouldAutoDetect) {
            if (this.mAutoDetector == null) {
                this.mAutoDetector = new NetworkChangeNotifierAutoDetect(new NetworkChangeNotifierAutoDetect.Observer(){

                    @Override
                    public void onConnectionTypeChanged(int newConnectionType) {
                        NetworkChangeNotifier.this.updateCurrentConnectionType(newConnectionType);
                    }

                    @Override
                    public void onConnectionSubtypeChanged(int newConnectionSubtype) {
                        NetworkChangeNotifier.this.notifyObserversOfConnectionSubtypeChange(newConnectionSubtype);
                    }

                    @Override
                    public void onNetworkConnect(long netId, int connectionType) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkConnect(netId, connectionType);
                    }

                    @Override
                    public void onNetworkSoonToDisconnect(long netId) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkSoonToDisconnect(netId);
                    }

                    @Override
                    public void onNetworkDisconnect(long netId) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkDisconnect(netId);
                    }

                    @Override
                    public void purgeActiveNetworkList(long[] activeNetIds) {
                        NetworkChangeNotifier.this.notifyObserversToPurgeActiveNetworkList(activeNetIds);
                    }
                }, policy);
                NetworkChangeNotifierAutoDetect.NetworkState networkState = this.mAutoDetector.getCurrentNetworkState();
                this.updateCurrentConnectionType(networkState.getConnectionType());
                this.notifyObserversOfConnectionSubtypeChange(networkState.getConnectionSubtype());
            }
        } else {
            this.destroyAutoDetector();
        }
    }

    @CalledByNative
    public static void forceConnectivityState(boolean networkAvailable) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().forceConnectivityStateInternal(networkAvailable);
    }

    private void forceConnectivityStateInternal(boolean forceOnline) {
        boolean connectionCurrentlyExists;
        boolean bl = connectionCurrentlyExists = this.mCurrentConnectionType != 6;
        if (connectionCurrentlyExists != forceOnline) {
            this.updateCurrentConnectionType(forceOnline ? 0 : 6);
            this.notifyObserversOfConnectionSubtypeChange(forceOnline ? 0 : 1);
        }
    }

    @CalledByNative
    public static void fakeNetworkConnected(long netId, int connectionType) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkConnect(netId, connectionType);
    }

    @CalledByNative
    public static void fakeNetworkSoonToBeDisconnected(long netId) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkSoonToDisconnect(netId);
    }

    @CalledByNative
    public static void fakeNetworkDisconnected(long netId) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkDisconnect(netId);
    }

    @CalledByNative
    public static void fakePurgeActiveNetworkList(long[] activeNetIds) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversToPurgeActiveNetworkList(activeNetIds);
    }

    @CalledByNative
    public static void fakeDefaultNetwork(long netId, int connectionType) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfConnectionTypeChange(connectionType, netId);
    }

    @CalledByNative
    public static void fakeConnectionSubtypeChanged(int connectionSubtype) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfConnectionSubtypeChange(connectionSubtype);
    }

    private void updateCurrentConnectionType(int newConnectionType) {
        this.mCurrentConnectionType = newConnectionType;
        this.notifyObserversOfConnectionTypeChange(newConnectionType);
    }

    void notifyObserversOfConnectionTypeChange(int newConnectionType) {
        this.notifyObserversOfConnectionTypeChange(newConnectionType, this.getCurrentDefaultNetId());
    }

    private void notifyObserversOfConnectionTypeChange(int newConnectionType, long defaultNetId) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyConnectionTypeChanged(nativeChangeNotifier, newConnectionType, defaultNetId);
        }
        for (ConnectionTypeObserver observer : this.mConnectionTypeObservers) {
            observer.onConnectionTypeChanged(newConnectionType);
        }
    }

    void notifyObserversOfConnectionSubtypeChange(int connectionSubtype) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyMaxBandwidthChanged(nativeChangeNotifier, connectionSubtype);
        }
    }

    void notifyObserversOfNetworkConnect(long netId, int connectionType) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyOfNetworkConnect(nativeChangeNotifier, netId, connectionType);
        }
    }

    void notifyObserversOfNetworkSoonToDisconnect(long netId) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyOfNetworkSoonToDisconnect(nativeChangeNotifier, netId);
        }
    }

    void notifyObserversOfNetworkDisconnect(long netId) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyOfNetworkDisconnect(nativeChangeNotifier, netId);
        }
    }

    void notifyObserversToPurgeActiveNetworkList(long[] activeNetIds) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyPurgeActiveNetworkList(nativeChangeNotifier, activeNetIds);
        }
    }

    public static void addConnectionTypeObserver(ConnectionTypeObserver observer) {
        NetworkChangeNotifier.getInstance().addConnectionTypeObserverInternal(observer);
    }

    private void addConnectionTypeObserverInternal(ConnectionTypeObserver observer) {
        this.mConnectionTypeObservers.addObserver(observer);
    }

    public static void removeConnectionTypeObserver(ConnectionTypeObserver observer) {
        NetworkChangeNotifier.getInstance().removeConnectionTypeObserverInternal(observer);
    }

    private void removeConnectionTypeObserverInternal(ConnectionTypeObserver observer) {
        this.mConnectionTypeObservers.removeObserver(observer);
    }

    private boolean isProcessBoundToNetworkInternal() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 23) {
            boolean returnValue = ConnectivityManager.getProcessDefaultNetwork() != null;
            return returnValue;
        }
        return ApiHelperForM.getBoundNetworkForProcess(this.mConnectivityManager) != null;
    }

    @CalledByNative
    public static boolean isProcessBoundToNetwork() {
        return NetworkChangeNotifier.getInstance().isProcessBoundToNetworkInternal();
    }

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyConnectionTypeChanged(long var1, int var3, long var4);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyMaxBandwidthChanged(long var1, int var3);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyOfNetworkConnect(long var1, long var3, int var5);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyOfNetworkSoonToDisconnect(long var1, long var3);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyOfNetworkDisconnect(long var1, long var3);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyPurgeActiveNetworkList(long var1, long[] var3);

    public static NetworkChangeNotifierAutoDetect getAutoDetectorForTest() {
        return NetworkChangeNotifier.getInstance().mAutoDetector;
    }

    public static boolean isOnline() {
        int connectionType = NetworkChangeNotifier.getInstance().getCurrentConnectionType();
        return connectionType != 6;
    }

    public static interface ConnectionTypeObserver {
        public void onConnectionTypeChanged(int var1);
    }
}

