/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.BuildConfig;
import org.chromium.base.ContextUtils;
import org.chromium.base.StrictModeContext;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.compat.ApiHelperForM;
import org.chromium.net.AndroidNetworkLibrary;

@SuppressLint(value={"NewApi"})
public class NetworkChangeNotifierAutoDetect
extends BroadcastReceiver {
    private static final String TAG = NetworkChangeNotifierAutoDetect.class.getSimpleName();
    private static final int UNKNOWN_LINK_SPEED = -1;
    private final Looper mLooper = Looper.myLooper();
    private final Handler mHandler = new Handler(this.mLooper);
    private final NetworkConnectivityIntentFilter mIntentFilter;
    private final Observer mObserver;
    private final RegistrationPolicy mRegistrationPolicy;
    private DefaultNetworkCallback mDefaultNetworkCallback;
    private ConnectivityManagerDelegate mConnectivityManagerDelegate;
    private WifiManagerDelegate mWifiManagerDelegate;
    private MyNetworkCallback mNetworkCallback;
    private NetworkRequest mNetworkRequest;
    private boolean mRegistered;
    private NetworkState mNetworkState;
    private boolean mIgnoreNextBroadcast;
    private boolean mShouldSignalObserver;
    private boolean mRegisterNetworkCallbackFailed;

    @TargetApi(value=21)
    public NetworkChangeNotifierAutoDetect(Observer observer, RegistrationPolicy policy) {
        this.mObserver = observer;
        this.mConnectivityManagerDelegate = new ConnectivityManagerDelegate(ContextUtils.getApplicationContext());
        if (Build.VERSION.SDK_INT < 23) {
            this.mWifiManagerDelegate = new WifiManagerDelegate(ContextUtils.getApplicationContext());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mNetworkCallback = new MyNetworkCallback();
            this.mNetworkRequest = new NetworkRequest.Builder().addCapability(12).removeCapability(15).build();
        } else {
            this.mNetworkCallback = null;
            this.mNetworkRequest = null;
        }
        this.mDefaultNetworkCallback = Build.VERSION.SDK_INT >= 28 ? new DefaultNetworkCallback() : null;
        this.mNetworkState = this.getCurrentNetworkState();
        this.mIntentFilter = new NetworkConnectivityIntentFilter();
        this.mIgnoreNextBroadcast = false;
        this.mShouldSignalObserver = false;
        this.mRegistrationPolicy = policy;
        this.mRegistrationPolicy.init(this);
        this.mShouldSignalObserver = true;
    }

    private boolean onThread() {
        return this.mLooper == Looper.myLooper();
    }

    private void assertOnThread() {
        if (BuildConfig.DCHECK_IS_ON && !this.onThread()) {
            throw new IllegalStateException("Must be called on NetworkChangeNotifierAutoDetect thread.");
        }
    }

    private void runOnThread(Runnable r) {
        if (this.onThread()) {
            r.run();
        } else {
            this.mHandler.post(r);
        }
    }

    void setConnectivityManagerDelegateForTests(ConnectivityManagerDelegate delegate) {
        this.mConnectivityManagerDelegate = delegate;
    }

    void setWifiManagerDelegateForTests(WifiManagerDelegate delegate) {
        this.mWifiManagerDelegate = delegate;
    }

    @VisibleForTesting
    RegistrationPolicy getRegistrationPolicy() {
        return this.mRegistrationPolicy;
    }

    @VisibleForTesting
    boolean isReceiverRegisteredForTesting() {
        return this.mRegistered;
    }

    public void destroy() {
        this.assertOnThread();
        this.mRegistrationPolicy.destroy();
        this.unregister();
    }

    public void register() {
        this.assertOnThread();
        if (this.mRegistered) {
            return;
        }
        if (this.mShouldSignalObserver) {
            this.connectionTypeChanged();
        }
        if (this.mDefaultNetworkCallback != null) {
            try {
                this.mConnectivityManagerDelegate.registerDefaultNetworkCallback(this.mDefaultNetworkCallback, this.mHandler);
            }
            catch (RuntimeException e) {
                this.mDefaultNetworkCallback = null;
            }
        }
        if (this.mDefaultNetworkCallback == null) {
            this.mIgnoreNextBroadcast = ContextUtils.getApplicationContext().registerReceiver((BroadcastReceiver)this, (IntentFilter)this.mIntentFilter) != null;
        }
        this.mRegistered = true;
        if (this.mNetworkCallback != null) {
            this.mNetworkCallback.initializeVpnInPlace();
            try {
                this.mConnectivityManagerDelegate.registerNetworkCallback(this.mNetworkRequest, this.mNetworkCallback, this.mHandler);
            }
            catch (RuntimeException e) {
                this.mRegisterNetworkCallbackFailed = true;
                this.mNetworkCallback = null;
            }
            if (!this.mRegisterNetworkCallbackFailed && this.mShouldSignalObserver) {
                Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this.mConnectivityManagerDelegate, null);
                long[] netIds = new long[networks.length];
                for (int i = 0; i < networks.length; ++i) {
                    netIds[i] = NetworkChangeNotifierAutoDetect.networkToNetId(networks[i]);
                }
                this.mObserver.purgeActiveNetworkList(netIds);
            }
        }
    }

    public void unregister() {
        this.assertOnThread();
        if (!this.mRegistered) {
            return;
        }
        this.mRegistered = false;
        if (this.mNetworkCallback != null) {
            this.mConnectivityManagerDelegate.unregisterNetworkCallback(this.mNetworkCallback);
        }
        if (this.mDefaultNetworkCallback != null) {
            this.mConnectivityManagerDelegate.unregisterNetworkCallback(this.mDefaultNetworkCallback);
        } else {
            ContextUtils.getApplicationContext().unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public NetworkState getCurrentNetworkState() {
        return this.mConnectivityManagerDelegate.getNetworkState(this.mWifiManagerDelegate);
    }

    @TargetApi(value=21)
    private static Network[] getAllNetworksFiltered(ConnectivityManagerDelegate connectivityManagerDelegate, Network ignoreNetwork) {
        Network[] networks = connectivityManagerDelegate.getAllNetworksUnfiltered();
        int filteredIndex = 0;
        for (Network network : networks) {
            NetworkCapabilities capabilities;
            if (network.equals((Object)ignoreNetwork) || (capabilities = connectivityManagerDelegate.getNetworkCapabilities(network)) == null || !capabilities.hasCapability(12)) continue;
            if (capabilities.hasTransport(4)) {
                if (!connectivityManagerDelegate.vpnAccessible(network)) continue;
                return new Network[]{network};
            }
            networks[filteredIndex++] = network;
        }
        return Arrays.copyOf(networks, filteredIndex);
    }

    public long[] getNetworksAndTypes() {
        if (Build.VERSION.SDK_INT < 21) {
            return new long[0];
        }
        Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this.mConnectivityManagerDelegate, null);
        long[] networksAndTypes = new long[networks.length * 2];
        int index = 0;
        for (Network network : networks) {
            networksAndTypes[index++] = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            networksAndTypes[index++] = this.mConnectivityManagerDelegate.getConnectionType(network);
        }
        return networksAndTypes;
    }

    public long getDefaultNetId() {
        if (Build.VERSION.SDK_INT < 21) {
            return -1L;
        }
        Network network = this.mConnectivityManagerDelegate.getDefaultNetwork();
        return network == null ? -1L : NetworkChangeNotifierAutoDetect.networkToNetId(network);
    }

    public boolean registerNetworkCallbackFailed() {
        return this.mRegisterNetworkCallbackFailed;
    }

    private static int convertToConnectionType(int type, int subtype) {
        switch (type) {
            case 9: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 7;
            }
            case 0: {
                switch (subtype) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 3;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 4;
                    }
                    case 13: {
                        return 5;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public void onReceive(Context context, Intent intent) {
        this.runOnThread(new Runnable(){

            @Override
            public void run() {
                if (!NetworkChangeNotifierAutoDetect.this.mRegistered) {
                    return;
                }
                if (NetworkChangeNotifierAutoDetect.this.mIgnoreNextBroadcast) {
                    NetworkChangeNotifierAutoDetect.this.mIgnoreNextBroadcast = false;
                    return;
                }
                NetworkChangeNotifierAutoDetect.this.connectionTypeChanged();
            }
        });
    }

    private void connectionTypeChanged() {
        NetworkState networkState = this.getCurrentNetworkState();
        if (networkState.getConnectionType() != this.mNetworkState.getConnectionType() || !networkState.getNetworkIdentifier().equals(this.mNetworkState.getNetworkIdentifier()) || networkState.isPrivateDnsActive() != this.mNetworkState.isPrivateDnsActive()) {
            this.mObserver.onConnectionTypeChanged(networkState.getConnectionType());
        }
        if (networkState.getConnectionType() != this.mNetworkState.getConnectionType() || networkState.getConnectionSubtype() != this.mNetworkState.getConnectionSubtype()) {
            this.mObserver.onConnectionSubtypeChanged(networkState.getConnectionSubtype());
        }
        this.mNetworkState = networkState;
    }

    @TargetApi(value=21)
    @VisibleForTesting
    static long networkToNetId(Network network) {
        if (Build.VERSION.SDK_INT >= 23) {
            return ApiHelperForM.getNetworkHandle(network);
        }
        return Integer.parseInt(network.toString());
    }

    private static class NetworkConnectivityIntentFilter
    extends IntentFilter {
        NetworkConnectivityIntentFilter() {
            this.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        }
    }

    public static interface Observer {
        public void onConnectionTypeChanged(int var1);

        public void onConnectionSubtypeChanged(int var1);

        public void onNetworkConnect(long var1, int var3);

        public void onNetworkSoonToDisconnect(long var1);

        public void onNetworkDisconnect(long var1);

        public void purgeActiveNetworkList(long[] var1);
    }

    public static abstract class RegistrationPolicy {
        private NetworkChangeNotifierAutoDetect mNotifier;

        protected final void register() {
            assert (this.mNotifier != null);
            this.mNotifier.register();
        }

        protected final void unregister() {
            assert (this.mNotifier != null);
            this.mNotifier.unregister();
        }

        protected void init(NetworkChangeNotifierAutoDetect notifier) {
            this.mNotifier = notifier;
        }

        protected abstract void destroy();
    }

    @TargetApi(value=21)
    private class MyNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private Network mVpnInPlace;

        private MyNetworkCallback() {
        }

        void initializeVpnInPlace() {
            NetworkCapabilities capabilities;
            Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate, null);
            this.mVpnInPlace = null;
            if (networks.length == 1 && (capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(networks[0])) != null && capabilities.hasTransport(4)) {
                this.mVpnInPlace = networks[0];
            }
        }

        private boolean ignoreNetworkDueToVpn(Network network) {
            return this.mVpnInPlace != null && !this.mVpnInPlace.equals((Object)network);
        }

        private boolean ignoreConnectedInaccessibleVpn(Network network, NetworkCapabilities capabilities) {
            if (capabilities == null) {
                capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(network);
            }
            return capabilities == null || capabilities.hasTransport(4) && !NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.vpnAccessible(network);
        }

        private boolean ignoreConnectedNetwork(Network network, NetworkCapabilities capabilities) {
            return this.ignoreNetworkDueToVpn(network) || this.ignoreConnectedInaccessibleVpn(network, capabilities);
        }

        public void onAvailable(Network network) {
            NetworkCapabilities capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(network);
            if (this.ignoreConnectedNetwork(network, capabilities)) {
                return;
            }
            final boolean makeVpnDefault = capabilities.hasTransport(4);
            if (makeVpnDefault) {
                this.mVpnInPlace = network;
            }
            final long netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            final int connectionType = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getConnectionType(network);
            NetworkChangeNotifierAutoDetect.this.runOnThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkConnect(netId, connectionType);
                    if (makeVpnDefault) {
                        NetworkChangeNotifierAutoDetect.this.mObserver.onConnectionTypeChanged(connectionType);
                        NetworkChangeNotifierAutoDetect.this.mObserver.purgeActiveNetworkList(new long[]{netId});
                    }
                }
            });
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            if (this.ignoreConnectedNetwork(network, networkCapabilities)) {
                return;
            }
            final long netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            final int connectionType = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getConnectionType(network);
            NetworkChangeNotifierAutoDetect.this.runOnThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkConnect(netId, connectionType);
                }
            });
        }

        public void onLosing(Network network, int maxMsToLive) {
            if (this.ignoreConnectedNetwork(network, null)) {
                return;
            }
            final long netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            NetworkChangeNotifierAutoDetect.this.runOnThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkSoonToDisconnect(netId);
                }
            });
        }

        public void onLost(final Network network) {
            if (this.ignoreNetworkDueToVpn(network)) {
                return;
            }
            NetworkChangeNotifierAutoDetect.this.runOnThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkDisconnect(NetworkChangeNotifierAutoDetect.networkToNetId(network));
                }
            });
            if (this.mVpnInPlace != null) {
                assert (network.equals((Object)this.mVpnInPlace));
                this.mVpnInPlace = null;
                for (Network newNetwork : NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate, network)) {
                    this.onAvailable(newNetwork);
                }
                final int newConnectionType = NetworkChangeNotifierAutoDetect.this.getCurrentNetworkState().getConnectionType();
                NetworkChangeNotifierAutoDetect.this.runOnThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkChangeNotifierAutoDetect.this.mObserver.onConnectionTypeChanged(newConnectionType);
                    }
                });
            }
        }
    }

    @TargetApi(value=21)
    private class DefaultNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private DefaultNetworkCallback() {
        }

        public void onAvailable(Network network) {
            if (NetworkChangeNotifierAutoDetect.this.mRegistered) {
                NetworkChangeNotifierAutoDetect.this.connectionTypeChanged();
            }
        }

        public void onLost(Network network) {
            this.onAvailable(null);
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            this.onAvailable(null);
        }
    }

    static class WifiManagerDelegate {
        private final Context mContext;
        private final Object mLock = new Object();
        @GuardedBy(value="mLock")
        private boolean mHasWifiPermissionComputed;
        @GuardedBy(value="mLock")
        private boolean mHasWifiPermission;
        @GuardedBy(value="mLock")
        private WifiManager mWifiManager;

        WifiManagerDelegate(Context context) {
            assert (Build.VERSION.SDK_INT < 23);
            this.mContext = context;
        }

        WifiManagerDelegate() {
            this.mContext = null;
        }

        @GuardedBy(value="mLock")
        @SuppressLint(value={"WifiManagerPotentialLeak"})
        private boolean hasPermissionLocked() {
            if (this.mHasWifiPermissionComputed) {
                return this.mHasWifiPermission;
            }
            this.mHasWifiPermission = this.mContext.getPackageManager().checkPermission("android.permission.ACCESS_WIFI_STATE", this.mContext.getPackageName()) == 0;
            this.mWifiManager = this.mHasWifiPermission ? (WifiManager)this.mContext.getSystemService("wifi") : null;
            this.mHasWifiPermissionComputed = true;
            return this.mHasWifiPermission;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getWifiSsid() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.hasPermissionLocked()) {
                    WifiInfo wifiInfo = this.getWifiInfoLocked();
                    if (wifiInfo != null) {
                        return wifiInfo.getSSID();
                    }
                    return "";
                }
            }
            return AndroidNetworkLibrary.getWifiSSID();
        }

        @GuardedBy(value="mLock")
        private WifiInfo getWifiInfoLocked() {
            try {
                return this.mWifiManager.getConnectionInfo();
            }
            catch (NullPointerException firstException) {
                try {
                    return this.mWifiManager.getConnectionInfo();
                }
                catch (NullPointerException secondException) {
                    return null;
                }
            }
        }
    }

    static class ConnectivityManagerDelegate {
        private final ConnectivityManager mConnectivityManager;

        ConnectivityManagerDelegate(Context context) {
            this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        ConnectivityManagerDelegate() {
            this.mConnectivityManager = null;
        }

        @TargetApi(value=21)
        private NetworkInfo processActiveNetworkInfo(NetworkInfo networkInfo) {
            if (networkInfo == null) {
                return null;
            }
            if (networkInfo.isConnected()) {
                return networkInfo;
            }
            if (Build.VERSION.SDK_INT < 21) {
                return null;
            }
            if (networkInfo.getDetailedState() != NetworkInfo.DetailedState.BLOCKED) {
                return null;
            }
            if (ApplicationStatus.getStateForApplication() != 1) {
                return null;
            }
            return networkInfo;
        }

        NetworkState getNetworkState(WifiManagerDelegate wifiManagerDelegate) {
            NetworkInfo networkInfo;
            Network network = null;
            if (Build.VERSION.SDK_INT >= 23) {
                network = this.getDefaultNetwork();
                networkInfo = ApiHelperForM.getNetworkInfo(this.mConnectivityManager, network);
            } else {
                networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            }
            networkInfo = this.processActiveNetworkInfo(networkInfo);
            if (networkInfo == null) {
                return new NetworkState(false, -1, -1, null, false);
            }
            if (network != null) {
                return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), String.valueOf(NetworkChangeNotifierAutoDetect.networkToNetId(network)), Build.VERSION.SDK_INT >= 28 && AndroidNetworkLibrary.isPrivateDnsActive(this.mConnectivityManager.getLinkProperties(network)));
            }
            assert (Build.VERSION.SDK_INT < 23);
            if (networkInfo.getType() == 1) {
                if (networkInfo.getExtraInfo() != null && !"".equals(networkInfo.getExtraInfo())) {
                    return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), networkInfo.getExtraInfo(), false);
                }
                return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), wifiManagerDelegate.getWifiSsid(), false);
            }
            return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype(), null, false);
        }

        private NetworkInfo getNetworkInfo(Network network) {
            try {
                return this.mConnectivityManager.getNetworkInfo(network);
            }
            catch (NullPointerException firstException) {
                try {
                    return this.mConnectivityManager.getNetworkInfo(network);
                }
                catch (NullPointerException secondException) {
                    return null;
                }
            }
        }

        @TargetApi(value=21)
        int getConnectionType(Network network) {
            NetworkInfo networkInfo = this.getNetworkInfo(network);
            if (networkInfo != null && networkInfo.getType() == 17) {
                networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            }
            if (networkInfo != null && networkInfo.isConnected()) {
                return NetworkChangeNotifierAutoDetect.convertToConnectionType(networkInfo.getType(), networkInfo.getSubtype());
            }
            return 6;
        }

        @TargetApi(value=21)
        @VisibleForTesting
        protected Network[] getAllNetworksUnfiltered() {
            Network[] networks = this.mConnectivityManager.getAllNetworks();
            return networks == null ? new Network[]{} : networks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TargetApi(value=21)
        @VisibleForTesting
        protected boolean vpnAccessible(Network network) {
            Socket s = new Socket();
            try (StrictModeContext unused = StrictModeContext.allowAllVmPolicies();){
                network.bindSocket(s);
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
            return true;
        }

        @TargetApi(value=21)
        @VisibleForTesting
        protected NetworkCapabilities getNetworkCapabilities(Network network) {
            return this.mConnectivityManager.getNetworkCapabilities(network);
        }

        @TargetApi(value=21)
        void registerNetworkCallback(NetworkRequest networkRequest, ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mConnectivityManager.registerNetworkCallback(networkRequest, networkCallback, handler);
            } else {
                this.mConnectivityManager.registerNetworkCallback(networkRequest, networkCallback);
            }
        }

        @TargetApi(value=28)
        void registerDefaultNetworkCallback(ConnectivityManager.NetworkCallback networkCallback, Handler handler) {
            this.mConnectivityManager.registerDefaultNetworkCallback(networkCallback, handler);
        }

        @TargetApi(value=21)
        void unregisterNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
            this.mConnectivityManager.unregisterNetworkCallback(networkCallback);
        }

        @TargetApi(value=21)
        Network getDefaultNetwork() {
            Network[] networks;
            Network defaultNetwork = null;
            if (Build.VERSION.SDK_INT >= 23 && (defaultNetwork = ApiHelperForM.getActiveNetwork(this.mConnectivityManager)) != null) {
                return defaultNetwork;
            }
            NetworkInfo defaultNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (defaultNetworkInfo == null) {
                return null;
            }
            for (Network network : networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this, null)) {
                NetworkInfo networkInfo = this.getNetworkInfo(network);
                if (networkInfo == null || networkInfo.getType() != defaultNetworkInfo.getType() && networkInfo.getType() != 17) continue;
                assert (defaultNetwork == null);
                defaultNetwork = network;
            }
            return defaultNetwork;
        }
    }

    public static class NetworkState {
        private final boolean mConnected;
        private final int mType;
        private final int mSubtype;
        private final String mNetworkIdentifier;
        private final boolean mIsPrivateDnsActive;

        public NetworkState(boolean connected, int type, int subtype, String networkIdentifier, boolean isPrivateDnsActive) {
            this.mConnected = connected;
            this.mType = type;
            this.mSubtype = subtype;
            this.mNetworkIdentifier = networkIdentifier == null ? "" : networkIdentifier;
            this.mIsPrivateDnsActive = isPrivateDnsActive;
        }

        public boolean isConnected() {
            return this.mConnected;
        }

        public int getNetworkType() {
            return this.mType;
        }

        public int getNetworkSubType() {
            return this.mSubtype;
        }

        public String getNetworkIdentifier() {
            return this.mNetworkIdentifier;
        }

        public int getConnectionType() {
            if (!this.isConnected()) {
                return 6;
            }
            return NetworkChangeNotifierAutoDetect.convertToConnectionType(this.getNetworkType(), this.getNetworkSubType());
        }

        public int getConnectionSubtype() {
            if (!this.isConnected()) {
                return 1;
            }
            switch (this.getNetworkType()) {
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    return 0;
                }
                case 0: {
                    switch (this.getNetworkSubType()) {
                        case 1: {
                            return 7;
                        }
                        case 2: {
                            return 8;
                        }
                        case 4: {
                            return 5;
                        }
                        case 7: {
                            return 6;
                        }
                        case 11: {
                            return 4;
                        }
                        case 3: {
                            return 9;
                        }
                        case 5: {
                            return 10;
                        }
                        case 6: {
                            return 11;
                        }
                        case 8: {
                            return 14;
                        }
                        case 9: {
                            return 15;
                        }
                        case 10: {
                            return 12;
                        }
                        case 12: {
                            return 13;
                        }
                        case 14: {
                            return 16;
                        }
                        case 15: {
                            return 17;
                        }
                        case 13: {
                            return 18;
                        }
                    }
                    return 0;
                }
            }
            return 0;
        }

        public boolean isPrivateDnsActive() {
            return this.mIsPrivateDnsActive;
        }
    }
}

