/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.annotation.SuppressLint;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.Log;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.NativeClassQualifiedName;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UploadDataSink;
import org.chromium.net.impl.CronetUrlRequest;
import org.chromium.net.impl.VersionSafeCallbacks;

@JNINamespace(value="cronet")
@VisibleForTesting
public final class CronetUploadDataStream
extends UploadDataSink {
    private static final String TAG = CronetUploadDataStream.class.getSimpleName();
    private final Executor mExecutor;
    private final VersionSafeCallbacks.UploadDataProviderWrapper mDataProvider;
    private final CronetUrlRequest mRequest;
    private long mLength;
    private long mRemainingLength;
    private long mByteBufferLimit;
    private final Runnable mReadTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CronetUploadDataStream.this.mLock;
            synchronized (object) {
                if (CronetUploadDataStream.this.mUploadDataStreamAdapter == 0L) {
                    return;
                }
                CronetUploadDataStream.this.checkState(3);
                if (CronetUploadDataStream.this.mByteBuffer == null) {
                    throw new IllegalStateException("Unexpected readData call. Buffer is null");
                }
                CronetUploadDataStream.this.mInWhichUserCallback = 0;
            }
            try {
                CronetUploadDataStream.this.checkCallingThread();
                assert (CronetUploadDataStream.this.mByteBuffer.position() == 0);
                CronetUploadDataStream.this.mDataProvider.read((UploadDataSink)CronetUploadDataStream.this, CronetUploadDataStream.this.mByteBuffer);
            }
            catch (Exception exception) {
                CronetUploadDataStream.this.onError(exception);
            }
        }
    };
    private ByteBuffer mByteBuffer;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private long mUploadDataStreamAdapter;
    @GuardedBy(value="mLock")
    private int mInWhichUserCallback = 3;
    @GuardedBy(value="mLock")
    private boolean mDestroyAdapterPostponed;
    private Runnable mOnDestroyedCallbackForTesting;

    public CronetUploadDataStream(UploadDataProvider dataProvider, Executor executor, CronetUrlRequest request) {
        this.mExecutor = executor;
        this.mDataProvider = new VersionSafeCallbacks.UploadDataProviderWrapper(dataProvider);
        this.mRequest = request;
    }

    @CalledByNative
    void readData(ByteBuffer byteBuffer) {
        this.mByteBuffer = byteBuffer;
        this.mByteBufferLimit = byteBuffer.limit();
        this.postTaskToExecutor(this.mReadTask);
    }

    @CalledByNative
    void rewind() {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = CronetUploadDataStream.this.mLock;
                synchronized (object) {
                    if (CronetUploadDataStream.this.mUploadDataStreamAdapter == 0L) {
                        return;
                    }
                    CronetUploadDataStream.this.checkState(3);
                    CronetUploadDataStream.this.mInWhichUserCallback = 1;
                }
                try {
                    CronetUploadDataStream.this.checkCallingThread();
                    CronetUploadDataStream.this.mDataProvider.rewind((UploadDataSink)CronetUploadDataStream.this);
                }
                catch (Exception exception) {
                    CronetUploadDataStream.this.onError(exception);
                }
            }
        };
        this.postTaskToExecutor(task);
    }

    private void checkCallingThread() {
        this.mRequest.checkCallingThread();
    }

    @GuardedBy(value="mLock")
    private void checkState(int mode) {
        if (this.mInWhichUserCallback != mode) {
            throw new IllegalStateException("Expected " + mode + ", but was " + this.mInWhichUserCallback);
        }
    }

    @CalledByNative
    void onUploadDataStreamDestroyed() {
        this.destroyAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable exception) {
        boolean sendClose;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInWhichUserCallback == 3) {
                throw new IllegalStateException("There is no read or rewind or length check in progress.");
            }
            sendClose = this.mInWhichUserCallback == 2;
            this.mInWhichUserCallback = 3;
            this.mByteBuffer = null;
            this.destroyAdapterIfPostponed();
        }
        if (sendClose) {
            try {
                this.mDataProvider.close();
            }
            catch (Exception e) {
                Log.e(TAG, "Failure closing data provider", e);
            }
        }
        this.mRequest.onUploadException(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DefaultLocale"})
    public void onReadSucceeded(boolean lastChunk) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkState(0);
            if (this.mByteBufferLimit != (long)this.mByteBuffer.limit()) {
                throw new IllegalStateException("ByteBuffer limit changed");
            }
            if (lastChunk && this.mLength >= 0L) {
                throw new IllegalArgumentException("Non-chunked upload can't have last chunk");
            }
            int bytesRead = this.mByteBuffer.position();
            this.mRemainingLength -= (long)bytesRead;
            if (this.mRemainingLength < 0L && this.mLength >= 0L) {
                throw new IllegalArgumentException(String.format("Read upload data length %d exceeds expected length %d", this.mLength - this.mRemainingLength, this.mLength));
            }
            this.mByteBuffer.position(0);
            this.mByteBuffer = null;
            this.mInWhichUserCallback = 3;
            this.destroyAdapterIfPostponed();
            if (this.mUploadDataStreamAdapter == 0L) {
                return;
            }
            this.nativeOnReadSucceeded(this.mUploadDataStreamAdapter, bytesRead, lastChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadError(Exception exception) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkState(0);
            this.onError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRewindSucceeded() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkState(1);
            this.mInWhichUserCallback = 3;
            this.mRemainingLength = this.mLength;
            if (this.mUploadDataStreamAdapter == 0L) {
                return;
            }
            this.nativeOnRewindSucceeded(this.mUploadDataStreamAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRewindError(Exception exception) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkState(1);
            this.onError(exception);
        }
    }

    void postTaskToExecutor(Runnable task) {
        try {
            this.mExecutor.execute(task);
        }
        catch (Throwable e) {
            this.mRequest.onUploadException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAdapter() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInWhichUserCallback == 0) {
                this.mDestroyAdapterPostponed = true;
                return;
            }
            if (this.mUploadDataStreamAdapter == 0L) {
                return;
            }
            CronetUploadDataStream.nativeDestroy(this.mUploadDataStreamAdapter);
            this.mUploadDataStreamAdapter = 0L;
            if (this.mOnDestroyedCallbackForTesting != null) {
                this.mOnDestroyedCallbackForTesting.run();
            }
        }
        this.postTaskToExecutor(new Runnable(){

            @Override
            public void run() {
                try {
                    CronetUploadDataStream.this.checkCallingThread();
                    CronetUploadDataStream.this.mDataProvider.close();
                }
                catch (Exception e) {
                    Log.e(TAG, "Exception thrown when closing", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAdapterIfPostponed() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInWhichUserCallback == 0) {
                throw new IllegalStateException("Method should not be called when read has not completed.");
            }
            if (this.mDestroyAdapterPostponed) {
                this.destroyAdapter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeWithRequest() {
        Object object = this.mLock;
        synchronized (object) {
            this.mInWhichUserCallback = 2;
        }
        try {
            this.mRequest.checkCallingThread();
            this.mRemainingLength = this.mLength = this.mDataProvider.getLength();
        }
        catch (Throwable t) {
            this.onError(t);
        }
        object = this.mLock;
        synchronized (object) {
            this.mInWhichUserCallback = 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachNativeAdapterToRequest(long requestAdapter) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUploadDataStreamAdapter = this.nativeAttachUploadDataToRequest(requestAdapter, this.mLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public long createUploadDataStreamForTesting() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            this.mUploadDataStreamAdapter = this.nativeCreateAdapterForTesting();
            this.mRemainingLength = this.mLength = this.mDataProvider.getLength();
            return this.nativeCreateUploadDataStreamForTesting(this.mLength, this.mUploadDataStreamAdapter);
        }
    }

    @VisibleForTesting
    void setOnDestroyedCallbackForTesting(Runnable onDestroyedCallbackForTesting) {
        this.mOnDestroyedCallbackForTesting = onDestroyedCallbackForTesting;
    }

    private native long nativeAttachUploadDataToRequest(long var1, long var3);

    private native long nativeCreateAdapterForTesting();

    private native long nativeCreateUploadDataStreamForTesting(long var1, long var3);

    @NativeClassQualifiedName(value="CronetUploadDataStreamAdapter")
    private native void nativeOnReadSucceeded(long var1, int var3, boolean var4);

    @NativeClassQualifiedName(value="CronetUploadDataStreamAdapter")
    private native void nativeOnRewindSucceeded(long var1);

    @NativeClassQualifiedName(value="CronetUploadDataStreamAdapter")
    private static native void nativeDestroy(long var0);

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface UserCallback {
        public static final int READ = 0;
        public static final int REWIND = 1;
        public static final int GET_LENGTH = 2;
        public static final int NOT_IN_CALLBACK = 3;
    }
}

