/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import androidx.annotation.NonNull;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;

final class InputStreamChannel
implements ReadableByteChannel {
    private static final int MAX_TMP_BUFFER_SIZE = 16384;
    private static final int MIN_TMP_BUFFER_SIZE = 4096;
    private final InputStream mInputStream;
    private final AtomicBoolean mIsOpen = new AtomicBoolean(true);

    private InputStreamChannel(@NonNull InputStream inputStream) {
        this.mInputStream = inputStream;
    }

    static ReadableByteChannel wrap(@NonNull InputStream inputStream) {
        if (inputStream instanceof FileInputStream) {
            return ((FileInputStream)inputStream).getChannel();
        }
        return new InputStreamChannel(inputStream);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read;
        if (dst.hasArray()) {
            read = this.mInputStream.read(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining());
            if (read > 0) {
                dst.position(dst.position() + read);
            }
        } else {
            int possibleToRead = Math.min(Math.max(this.mInputStream.available(), 4096), dst.remaining());
            int reasonableToRead = Math.min(16384, possibleToRead);
            byte[] tmpBuf = new byte[reasonableToRead];
            read = this.mInputStream.read(tmpBuf);
            if (read > 0) {
                dst.put(tmpBuf, 0, read);
            }
        }
        return read;
    }

    @Override
    public boolean isOpen() {
        return this.mIsOpen.get();
    }

    @Override
    public void close() throws IOException {
        if (this.mIsOpen.compareAndSet(true, false)) {
            this.mInputStream.close();
        }
    }
}

