/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.chromium.net.BidirectionalStream;
import org.chromium.net.ExperimentalBidirectionalStream;
import org.chromium.net.NetworkQualityRttListener;
import org.chromium.net.NetworkQualityThroughputListener;
import org.chromium.net.RequestFinishedInfo;
import org.chromium.net.UrlRequest;
import org.chromium.net.impl.CronetEngineBase;
import org.chromium.net.impl.CronetEngineBuilderImpl;
import org.chromium.net.impl.CronetLogger;
import org.chromium.net.impl.CronetLoggerFactory;
import org.chromium.net.impl.ImplVersion;
import org.chromium.net.impl.JavaUrlRequest;
import org.chromium.net.impl.UrlRequestBase;

public final class JavaCronetEngine
extends CronetEngineBase {
    private static final String TAG = JavaCronetEngine.class.getSimpleName();
    private final String mUserAgent;
    private final ExecutorService mExecutorService;
    private final int mCronetEngineId;
    private final CronetLogger mLogger;
    private final AtomicInteger mActiveRequestCount = new AtomicInteger();
    private long mNetworkHandle = -1L;
    private final Context mContext;

    public JavaCronetEngine(CronetEngineBuilderImpl builder) {
        this.mContext = builder.getContext();
        this.mCronetEngineId = ((Object)((Object)this)).hashCode();
        final int threadPriority = builder.threadPriority(9);
        this.mUserAgent = builder.getUserAgent();
        this.mExecutorService = new ThreadPoolExecutor(10, 10, 50L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(final Runnable r) {
                return Executors.defaultThreadFactory().newThread(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setName("JavaCronetEngine");
                        Process.setThreadPriority((int)threadPriority);
                        r.run();
                    }
                });
            }
        });
        this.mLogger = CronetLoggerFactory.createNoOpLogger();
        try {
            this.mLogger.logCronetEngineCreation(this.mCronetEngineId, new CronetLogger.CronetEngineBuilderInfo(builder), this.buildCronetVersion(), CronetLogger.CronetSource.CRONET_SOURCE_FALLBACK);
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Error while trying to log JavaCronetEngine creation: ", (Throwable)e);
        }
        Log.w((String)TAG, (String)"using the fallback Cronet Engine implementation. Performance will suffer and many HTTP client features, including caching, will not work.");
    }

    void incrementActiveRequestCount() {
        this.mActiveRequestCount.incrementAndGet();
    }

    void decrementActiveRequestCount() {
        this.mActiveRequestCount.decrementAndGet();
    }

    int getCronetEngineId() {
        return this.mCronetEngineId;
    }

    CronetLogger getCronetLogger() {
        return this.mLogger;
    }

    Context getContext() {
        return this.mContext;
    }

    public UrlRequestBase createRequest(String url, UrlRequest.Callback callback, Executor executor, int priority, Collection<Object> connectionAnnotations, boolean disableCache, boolean disableConnectionMigration, boolean allowDirectExecutor, boolean trafficStatsTagSet, int trafficStatsTag, boolean trafficStatsUidSet, int trafficStatsUid, RequestFinishedInfo.Listener requestFinishedListener, int idempotency, long networkHandle) {
        if (networkHandle != -1L) {
            this.mNetworkHandle = networkHandle;
        }
        return new JavaUrlRequest(this, callback, this.mExecutorService, executor, url, this.mUserAgent, allowDirectExecutor, trafficStatsTagSet, trafficStatsTag, trafficStatsUidSet, trafficStatsUid, this.mNetworkHandle);
    }

    protected ExperimentalBidirectionalStream createBidirectionalStream(String url, BidirectionalStream.Callback callback, Executor executor, String httpMethod, List<Map.Entry<String, String>> requestHeaders, int priority, boolean delayRequestHeadersUntilFirstFlush, Collection<Object> connectionAnnotations, boolean trafficStatsTagSet, int trafficStatsTag, boolean trafficStatsUidSet, int trafficStatsUid, long networkHandle) {
        throw new UnsupportedOperationException("Can't create a bidi stream - httpurlconnection doesn't have those APIs");
    }

    public ExperimentalBidirectionalStream.Builder newBidirectionalStreamBuilder(String url, BidirectionalStream.Callback callback, Executor executor) {
        throw new UnsupportedOperationException("The bidirectional stream API is not supported by the Java implementation of Cronet Engine");
    }

    public String getVersionString() {
        return "CronetHttpURLConnection/" + ImplVersion.getCronetVersionWithLastChange();
    }

    private CronetLogger.CronetVersion buildCronetVersion() {
        String version = this.getVersionString();
        version = version.split("/")[1];
        version = version.split("@")[0];
        return new CronetLogger.CronetVersion(version);
    }

    public void shutdown() {
        this.mExecutorService.shutdown();
    }

    public void startNetLogToFile(String fileName, boolean logAll) {
    }

    public void startNetLogToDisk(String dirPath, boolean logAll, int maxSize) {
    }

    public void stopNetLog() {
    }

    public byte[] getGlobalMetricsDeltas() {
        return new byte[0];
    }

    public int getEffectiveConnectionType() {
        return 0;
    }

    public int getHttpRttMs() {
        return -1;
    }

    public int getTransportRttMs() {
        return -1;
    }

    public int getDownstreamThroughputKbps() {
        return -1;
    }

    public int getActiveRequestCount() {
        return this.mActiveRequestCount.get();
    }

    public void bindToNetwork(long networkHandle) {
        if (Build.VERSION.SDK_INT < 23) {
            throw new UnsupportedOperationException("This multi-network Java implementation is available starting from Android Pie");
        }
        this.mNetworkHandle = networkHandle;
    }

    public void configureNetworkQualityEstimatorForTesting(boolean useLocalHostRequests, boolean useSmallerResponses, boolean disableOfflineCheck) {
    }

    public void addRttListener(NetworkQualityRttListener listener) {
    }

    public void removeRttListener(NetworkQualityRttListener listener) {
    }

    public void addThroughputListener(NetworkQualityThroughputListener listener) {
    }

    public void removeThroughputListener(NetworkQualityThroughputListener listener) {
    }

    public void addRequestFinishedListener(RequestFinishedInfo.Listener listener) {
    }

    public void removeRequestFinishedListener(RequestFinishedInfo.Listener listener) {
    }

    public URLConnection openConnection(URL url) throws IOException {
        return url.openConnection();
    }

    public URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        return url.openConnection(proxy);
    }

    public URLStreamHandlerFactory createURLStreamHandlerFactory() {
        return new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                return null;
            }
        };
    }
}

