/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.TrafficStats;
import android.os.Build;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.net.CronetException;
import org.chromium.net.InlineExecutionProhibitedException;
import org.chromium.net.ThreadStatsUid;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UrlRequest;
import org.chromium.net.UrlResponseInfo;
import org.chromium.net.impl.CallbackExceptionImpl;
import org.chromium.net.impl.CronetExceptionImpl;
import org.chromium.net.impl.CronetLogger;
import org.chromium.net.impl.InputStreamChannel;
import org.chromium.net.impl.JavaCronetEngine;
import org.chromium.net.impl.JavaUploadDataSinkBase;
import org.chromium.net.impl.JavaUrlRequestUtils;
import org.chromium.net.impl.NetworkExceptionImpl;
import org.chromium.net.impl.Preconditions;
import org.chromium.net.impl.UrlRequestBase;
import org.chromium.net.impl.UrlResponseInfoImpl;
import org.chromium.net.impl.VersionSafeCallbacks;

final class JavaUrlRequest
extends UrlRequestBase {
    private static final String X_ANDROID = "X-Android";
    private static final String X_ANDROID_SELECTED_TRANSPORT = "X-Android-Selected-Transport";
    private static final String TAG = JavaUrlRequest.class.getSimpleName();
    private static final int DEFAULT_CHUNK_LENGTH = 8192;
    private static final String USER_AGENT = "User-Agent";
    private final AsyncUrlRequestCallback mCallbackAsync;
    private final Executor mExecutor;
    private final String mUserAgent;
    private final Map<String, String> mRequestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final List<String> mUrlChain = new ArrayList<String>();
    private final AtomicInteger mState = new AtomicInteger(0);
    private final AtomicBoolean mUploadProviderClosed = new AtomicBoolean(false);
    private final boolean mAllowDirectExecutor;
    private String mInitialMethod;
    private VersionSafeCallbacks.UploadDataProviderWrapper mUploadDataProvider;
    private Executor mUploadExecutor;
    private volatile int mAdditionalStatusDetails = -1;
    private String mCurrentUrl;
    @Nullable
    private ReadableByteChannel mResponseChannel;
    private UrlResponseInfoImpl mUrlResponseInfo;
    private String mPendingRedirectUrl;
    private HttpURLConnection mCurrentUrlConnection;
    private OutputStreamDataSink mOutputStreamDataSink;
    private final JavaCronetEngine mEngine;
    private final int mCronetEngineId;
    private final CronetLogger mLogger;
    private final long mNetworkHandle;

    JavaUrlRequest(JavaCronetEngine engine, UrlRequest.Callback callback, final Executor executor, Executor userExecutor, String url, String userAgent, boolean allowDirectExecutor, boolean trafficStatsTagSet, int trafficStatsTag, final boolean trafficStatsUidSet, final int trafficStatsUid, long networkHandle) {
        Objects.requireNonNull(url, "URL is required");
        Objects.requireNonNull(callback, "Listener is required");
        Objects.requireNonNull(executor, "Executor is required");
        Objects.requireNonNull(userExecutor, "userExecutor is required");
        this.mAllowDirectExecutor = allowDirectExecutor;
        this.mCallbackAsync = new AsyncUrlRequestCallback(callback, userExecutor);
        final int trafficStatsTagToUse = trafficStatsTagSet ? trafficStatsTag : TrafficStats.getThreadStatsTag();
        this.mExecutor = new SerializingExecutor(new Executor(){

            @Override
            public void execute(final Runnable command) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        int oldTag = TrafficStats.getThreadStatsTag();
                        TrafficStats.setThreadStatsTag((int)trafficStatsTagToUse);
                        if (trafficStatsUidSet) {
                            ThreadStatsUid.set((int)trafficStatsUid);
                        }
                        try {
                            command.run();
                        }
                        finally {
                            if (trafficStatsUidSet) {
                                ThreadStatsUid.clear();
                            }
                            TrafficStats.setThreadStatsTag((int)oldTag);
                        }
                    }
                });
            }
        });
        this.mEngine = engine;
        this.mCronetEngineId = engine.getCronetEngineId();
        this.mLogger = engine.getCronetLogger();
        this.mCurrentUrl = url;
        this.mUserAgent = userAgent;
        this.mNetworkHandle = networkHandle;
    }

    public void setHttpMethod(String method) {
        this.checkNotStarted();
        if (method == null) {
            throw new NullPointerException("Method is required.");
        }
        if (!("OPTIONS".equalsIgnoreCase(method) || "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method) || "TRACE".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method))) {
            throw new IllegalArgumentException("Invalid http method " + method);
        }
        this.mInitialMethod = method;
    }

    private void checkNotStarted() {
        int state = this.mState.get();
        if (state != 0) {
            throw new IllegalStateException("Request is already started. State is: " + state);
        }
    }

    public void addHeader(String header, String value) {
        this.checkNotStarted();
        if (!this.isValidHeaderName(header) || value.contains("\r\n")) {
            throw new IllegalArgumentException("Invalid header " + header + "=" + value);
        }
        if (this.mRequestHeaders.containsKey(header)) {
            this.mRequestHeaders.remove(header);
        }
        this.mRequestHeaders.put(header, value);
    }

    private boolean isValidHeaderName(String header) {
        for (int i = 0; i < header.length(); ++i) {
            char c = header.charAt(i);
            switch (c) {
                case '\'': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
            if (!Character.isISOControl(c) && !Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public void setUploadDataProvider(UploadDataProvider uploadDataProvider, Executor executor) {
        if (uploadDataProvider == null) {
            throw new NullPointerException("Invalid UploadDataProvider.");
        }
        if (!this.mRequestHeaders.containsKey("Content-Type")) {
            throw new IllegalArgumentException("Requests with upload data must have a Content-Type.");
        }
        this.checkNotStarted();
        if (this.mInitialMethod == null) {
            this.mInitialMethod = "POST";
        }
        this.mUploadDataProvider = new VersionSafeCallbacks.UploadDataProviderWrapper(uploadDataProvider);
        this.mUploadExecutor = this.mAllowDirectExecutor ? executor : new JavaUrlRequestUtils.DirectPreventingExecutor(executor);
    }

    public void start() {
        this.mAdditionalStatusDetails = 10;
        this.mEngine.incrementActiveRequestCount();
        this.transitionStates(0, 1, new Runnable(){

            @Override
            public void run() {
                JavaUrlRequest.this.mUrlChain.add(JavaUrlRequest.this.mCurrentUrl);
                JavaUrlRequest.this.fireOpenConnection();
            }
        });
    }

    private void enterErrorState(CronetException error) {
        if (this.setTerminalState(6)) {
            this.fireDisconnect();
            this.fireCloseUploadDataProvider();
            this.mCallbackAsync.onFailed((UrlResponseInfo)this.mUrlResponseInfo, error);
        }
    }

    private boolean setTerminalState(int error) {
        int oldState;
        do {
            oldState = this.mState.get();
            switch (oldState) {
                case 0: {
                    throw new IllegalStateException("Can't enter error state before start");
                }
                case 6: 
                case 7: 
                case 8: {
                    return false;
                }
            }
        } while (!this.mState.compareAndSet(oldState, error));
        return true;
    }

    private void enterUserErrorState(Throwable error) {
        this.enterErrorState((CronetException)new CallbackExceptionImpl("Exception received from UrlRequest.Callback", error));
    }

    private void enterUploadErrorState(Throwable error) {
        this.enterErrorState((CronetException)new CallbackExceptionImpl("Exception received from UploadDataProvider", error));
    }

    private void enterCronetErrorState(Throwable error) {
        this.enterErrorState((CronetException)new CronetExceptionImpl("System error", error));
    }

    private void transitionStates(int expected, int newState, Runnable afterTransition) {
        if (!this.mState.compareAndSet(expected, newState)) {
            int state = this.mState.get();
            if (state != 8 && state != 6) {
                throw new IllegalStateException("Invalid state transition - expected " + expected + " but was " + state);
            }
        } else {
            afterTransition.run();
        }
    }

    public void followRedirect() {
        this.transitionStates(3, 1, new Runnable(){

            @Override
            public void run() {
                JavaUrlRequest.this.mCurrentUrl = JavaUrlRequest.this.mPendingRedirectUrl;
                JavaUrlRequest.this.mPendingRedirectUrl = null;
                JavaUrlRequest.this.fireOpenConnection();
            }
        });
    }

    private void fireGetHeaders() {
        this.mAdditionalStatusDetails = 13;
        this.mExecutor.execute(this.errorSetting(new JavaUrlRequestUtils.CheckedRunnable(){

            public void run() throws Exception {
                List locationFields;
                String headerKey;
                if (JavaUrlRequest.this.mCurrentUrlConnection == null) {
                    return;
                }
                ArrayList<AbstractMap.SimpleEntry<String, String>> headerList = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                String selectedTransport = "http/1.1";
                int i = 0;
                while ((headerKey = JavaUrlRequest.this.mCurrentUrlConnection.getHeaderFieldKey(i)) != null) {
                    if (JavaUrlRequest.X_ANDROID_SELECTED_TRANSPORT.equalsIgnoreCase(headerKey)) {
                        selectedTransport = JavaUrlRequest.this.mCurrentUrlConnection.getHeaderField(i);
                    }
                    if (!headerKey.startsWith(JavaUrlRequest.X_ANDROID)) {
                        headerList.add(new AbstractMap.SimpleEntry<String, String>(headerKey, JavaUrlRequest.this.mCurrentUrlConnection.getHeaderField(i)));
                    }
                    ++i;
                }
                int responseCode = JavaUrlRequest.this.mCurrentUrlConnection.getResponseCode();
                JavaUrlRequest.this.mUrlResponseInfo = new UrlResponseInfoImpl(new ArrayList<String>(JavaUrlRequest.this.mUrlChain), responseCode, JavaUrlRequest.this.mCurrentUrlConnection.getResponseMessage(), Collections.unmodifiableList(headerList), false, selectedTransport, "", 0L);
                if (responseCode >= 300 && responseCode < 400 && (locationFields = (List)JavaUrlRequest.this.mUrlResponseInfo.getAllHeaders().get("location")) != null) {
                    JavaUrlRequest.this.fireRedirectReceived((String)locationFields.get(0));
                    return;
                }
                JavaUrlRequest.this.fireCloseUploadDataProvider();
                if (responseCode >= 400) {
                    InputStream inputStream = JavaUrlRequest.this.mCurrentUrlConnection.getErrorStream();
                    JavaUrlRequest.this.mResponseChannel = inputStream == null ? null : InputStreamChannel.wrap(inputStream);
                    JavaUrlRequest.this.mCallbackAsync.onResponseStarted((UrlResponseInfo)JavaUrlRequest.this.mUrlResponseInfo);
                } else {
                    JavaUrlRequest.this.mResponseChannel = InputStreamChannel.wrap(JavaUrlRequest.this.mCurrentUrlConnection.getInputStream());
                    JavaUrlRequest.this.mCallbackAsync.onResponseStarted((UrlResponseInfo)JavaUrlRequest.this.mUrlResponseInfo);
                }
            }
        }));
    }

    private void fireCloseUploadDataProvider() {
        if (this.mUploadDataProvider != null && this.mUploadProviderClosed.compareAndSet(false, true)) {
            try {
                this.mUploadExecutor.execute(this.uploadErrorSetting(new JavaUrlRequestUtils.CheckedRunnable(){

                    public void run() throws Exception {
                        JavaUrlRequest.this.mUploadDataProvider.close();
                    }
                }));
            }
            catch (RejectedExecutionException e) {
                Log.e((String)TAG, (String)"Exception when closing uploadDataProvider", (Throwable)e);
            }
        }
    }

    private void fireRedirectReceived(final String locationField) {
        this.transitionStates(1, 2, new Runnable(){

            @Override
            public void run() {
                JavaUrlRequest.this.mPendingRedirectUrl = URI.create(JavaUrlRequest.this.mCurrentUrl).resolve(locationField).toString();
                JavaUrlRequest.this.mUrlChain.add(JavaUrlRequest.this.mPendingRedirectUrl);
                JavaUrlRequest.this.transitionStates(2, 3, new Runnable(){

                    @Override
                    public void run() {
                        JavaUrlRequest.this.mCallbackAsync.onRedirectReceived((UrlResponseInfo)JavaUrlRequest.this.mUrlResponseInfo, JavaUrlRequest.this.mPendingRedirectUrl);
                    }
                });
            }
        });
    }

    private void fireOpenConnection() {
        this.mExecutor.execute(this.errorSetting(new JavaUrlRequestUtils.CheckedRunnable(){

            public void run() throws Exception {
                if (JavaUrlRequest.this.mState.get() == 8) {
                    return;
                }
                URL url = new URL(JavaUrlRequest.this.mCurrentUrl);
                if (JavaUrlRequest.this.mCurrentUrlConnection != null) {
                    JavaUrlRequest.this.mCurrentUrlConnection.disconnect();
                    JavaUrlRequest.this.mCurrentUrlConnection = null;
                }
                if (JavaUrlRequest.this.mNetworkHandle == -1L || Build.VERSION.SDK_INT < 23) {
                    JavaUrlRequest.this.mCurrentUrlConnection = (HttpURLConnection)url.openConnection();
                } else {
                    Network network = JavaUrlRequest.this.getNetworkFromHandle(JavaUrlRequest.this.mNetworkHandle);
                    if (network == null) {
                        throw new NetworkExceptionImpl("Network bound to request not found", 9, -4);
                    }
                    JavaUrlRequest.this.mCurrentUrlConnection = (HttpURLConnection)network.openConnection(url);
                }
                JavaUrlRequest.this.mCurrentUrlConnection.setInstanceFollowRedirects(false);
                if (!JavaUrlRequest.this.mRequestHeaders.containsKey(JavaUrlRequest.USER_AGENT)) {
                    JavaUrlRequest.this.mRequestHeaders.put(JavaUrlRequest.USER_AGENT, JavaUrlRequest.this.mUserAgent);
                }
                for (Map.Entry<String, String> entry : JavaUrlRequest.this.mRequestHeaders.entrySet()) {
                    JavaUrlRequest.this.mCurrentUrlConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
                if (JavaUrlRequest.this.mInitialMethod == null) {
                    JavaUrlRequest.this.mInitialMethod = "GET";
                }
                JavaUrlRequest.this.mCurrentUrlConnection.setRequestMethod(JavaUrlRequest.this.mInitialMethod);
                if (JavaUrlRequest.this.mUploadDataProvider != null) {
                    JavaUrlRequest.this.mOutputStreamDataSink = new OutputStreamDataSink(JavaUrlRequest.this.mUploadExecutor, JavaUrlRequest.this.mExecutor, JavaUrlRequest.this.mCurrentUrlConnection, JavaUrlRequest.this.mUploadDataProvider);
                    JavaUrlRequest.this.mOutputStreamDataSink.start(JavaUrlRequest.this.mUrlChain.size() == 1);
                } else {
                    JavaUrlRequest.this.mAdditionalStatusDetails = 10;
                    JavaUrlRequest.this.mCurrentUrlConnection.connect();
                    JavaUrlRequest.this.fireGetHeaders();
                }
            }
        }));
    }

    private Runnable errorSetting(final JavaUrlRequestUtils.CheckedRunnable delegate) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    delegate.run();
                }
                catch (Throwable t) {
                    JavaUrlRequest.this.enterCronetErrorState(t);
                }
            }
        };
    }

    private Runnable userErrorSetting(final JavaUrlRequestUtils.CheckedRunnable delegate) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    delegate.run();
                }
                catch (Throwable t) {
                    JavaUrlRequest.this.enterUserErrorState(t);
                }
            }
        };
    }

    private Runnable uploadErrorSetting(final JavaUrlRequestUtils.CheckedRunnable delegate) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    delegate.run();
                }
                catch (Throwable t) {
                    JavaUrlRequest.this.enterUploadErrorState(t);
                }
            }
        };
    }

    public void read(final ByteBuffer buffer) {
        Preconditions.checkDirect((ByteBuffer)buffer);
        Preconditions.checkHasRemaining((ByteBuffer)buffer);
        this.transitionStates(4, 5, new Runnable(){

            @Override
            public void run() {
                JavaUrlRequest.this.mExecutor.execute(JavaUrlRequest.this.errorSetting(new JavaUrlRequestUtils.CheckedRunnable(){

                    public void run() throws Exception {
                        int read = JavaUrlRequest.this.mResponseChannel == null ? -1 : JavaUrlRequest.this.mResponseChannel.read(buffer);
                        JavaUrlRequest.this.processReadResult(read, buffer);
                    }
                }));
            }
        });
    }

    private void processReadResult(int read, ByteBuffer buffer) throws IOException {
        if (read != -1) {
            this.mCallbackAsync.onReadCompleted((UrlResponseInfo)this.mUrlResponseInfo, buffer);
        } else {
            if (this.mResponseChannel != null) {
                this.mResponseChannel.close();
            }
            if (this.mState.compareAndSet(5, 7)) {
                this.fireDisconnect();
                this.mCallbackAsync.onSucceeded((UrlResponseInfo)this.mUrlResponseInfo);
            }
        }
    }

    private void fireDisconnect() {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (JavaUrlRequest.this.mOutputStreamDataSink != null) {
                    try {
                        JavaUrlRequest.this.mOutputStreamDataSink.closeOutputChannel();
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"Exception when closing OutputChannel", (Throwable)e);
                    }
                }
                if (JavaUrlRequest.this.mCurrentUrlConnection != null) {
                    JavaUrlRequest.this.mCurrentUrlConnection.disconnect();
                    JavaUrlRequest.this.mCurrentUrlConnection = null;
                }
            }
        });
    }

    public void cancel() {
        int oldState = this.mState.getAndSet(8);
        switch (oldState) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.fireDisconnect();
                this.fireCloseUploadDataProvider();
                this.mCallbackAsync.onCanceled((UrlResponseInfo)this.mUrlResponseInfo);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
    }

    public boolean isDone() {
        int state = this.mState.get();
        return state == 7 || state == 6 || state == 8;
    }

    @VisibleForTesting
    static long estimateHeadersSizeInBytesList(Map<String, List<String>> headers) {
        if (headers == null) {
            return 0L;
        }
        long responseHeaderSizeInBytes = 0L;
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (key != null) {
                responseHeaderSizeInBytes += (long)key.length();
            }
            if (entry.getValue() == null) continue;
            for (String content : entry.getValue()) {
                if (content == null) continue;
                responseHeaderSizeInBytes += (long)content.length();
            }
        }
        return responseHeaderSizeInBytes;
    }

    @VisibleForTesting
    static long estimateHeadersSizeInBytes(Map<String, String> headers) {
        if (headers == null) {
            return 0L;
        }
        long responseHeaderSizeInBytes = 0L;
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String value;
            String key = entry.getKey();
            if (key != null) {
                responseHeaderSizeInBytes += (long)key.length();
            }
            if ((value = entry.getValue()) == null) continue;
            responseHeaderSizeInBytes += (long)value.length();
        }
        return responseHeaderSizeInBytes;
    }

    private static long parseContentLengthString(String contentLength) {
        try {
            return Long.parseLong(contentLength);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public void getStatus(UrlRequest.StatusListener listener) {
        int status;
        int state = this.mState.get();
        int extraStatus = this.mAdditionalStatusDetails;
        switch (state) {
            case 0: 
            case 6: 
            case 7: 
            case 8: {
                status = -1;
                break;
            }
            case 1: {
                status = extraStatus;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                status = 0;
                break;
            }
            case 5: {
                status = 14;
                break;
            }
            default: {
                throw new IllegalStateException("Switch is exhaustive: " + state);
            }
        }
        this.mCallbackAsync.sendStatus(new VersionSafeCallbacks.UrlRequestStatusListener(listener), status);
    }

    private void closeResponseChannel() {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (JavaUrlRequest.this.mResponseChannel != null) {
                    try {
                        JavaUrlRequest.this.mResponseChannel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    JavaUrlRequest.this.mResponseChannel = null;
                }
            }
        });
    }

    private Network getNetworkFromHandle(long networkHandle) {
        Network[] networks;
        for (Network network : networks = ((ConnectivityManager)this.mEngine.getContext().getSystemService("connectivity")).getAllNetworks()) {
            if (network.getNetworkHandle() != networkHandle) continue;
            return network;
        }
        return null;
    }

    private final class AsyncUrlRequestCallback {
        final VersionSafeCallbacks.UrlRequestCallback mCallback;
        final Executor mUserExecutor;
        final Executor mFallbackExecutor;

        AsyncUrlRequestCallback(UrlRequest.Callback callback, Executor userExecutor) {
            this.mCallback = new VersionSafeCallbacks.UrlRequestCallback(callback);
            if (JavaUrlRequest.this.mAllowDirectExecutor) {
                this.mUserExecutor = userExecutor;
                this.mFallbackExecutor = null;
            } else {
                this.mUserExecutor = new JavaUrlRequestUtils.DirectPreventingExecutor(userExecutor);
                this.mFallbackExecutor = userExecutor;
            }
        }

        void sendStatus(final VersionSafeCallbacks.UrlRequestStatusListener listener, final int status) {
            this.mUserExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.onStatus(status);
                }
            });
        }

        void execute(JavaUrlRequestUtils.CheckedRunnable runnable) {
            try {
                this.mUserExecutor.execute(JavaUrlRequest.this.userErrorSetting(runnable));
            }
            catch (RejectedExecutionException e) {
                JavaUrlRequest.this.enterErrorState((CronetException)new CronetExceptionImpl("Exception posting task to executor", (Throwable)e));
            }
        }

        void onRedirectReceived(final UrlResponseInfo info, final String newLocationUrl) {
            this.execute(new JavaUrlRequestUtils.CheckedRunnable(){

                public void run() throws Exception {
                    AsyncUrlRequestCallback.this.mCallback.onRedirectReceived((UrlRequest)JavaUrlRequest.this, info, newLocationUrl);
                }
            });
        }

        void onResponseStarted(UrlResponseInfo info) {
            this.execute(new JavaUrlRequestUtils.CheckedRunnable(){

                public void run() throws Exception {
                    if (JavaUrlRequest.this.mState.compareAndSet(1, 4)) {
                        AsyncUrlRequestCallback.this.mCallback.onResponseStarted((UrlRequest)JavaUrlRequest.this, (UrlResponseInfo)JavaUrlRequest.this.mUrlResponseInfo);
                    }
                }
            });
        }

        void onReadCompleted(final UrlResponseInfo info, final ByteBuffer byteBuffer) {
            this.execute(new JavaUrlRequestUtils.CheckedRunnable(){

                public void run() throws Exception {
                    if (JavaUrlRequest.this.mState.compareAndSet(5, 4)) {
                        AsyncUrlRequestCallback.this.mCallback.onReadCompleted((UrlRequest)JavaUrlRequest.this, info, byteBuffer);
                    }
                }
            });
        }

        @RequiresApi(value=26)
        private CronetLogger.CronetTrafficInfo buildCronetTrafficInfo() {
            long responseBodySizeInBytes;
            long responseHeaderSizeInBytes;
            long requestBodySizeInBytes;
            long requestHeaderSizeInBytes;
            boolean wasCached;
            int httpStatusCode;
            String negotiatedProtocol;
            Map responseHeaders;
            assert (JavaUrlRequest.this.mRequestHeaders != null);
            if (JavaUrlRequest.this.mUrlResponseInfo != null) {
                responseHeaders = JavaUrlRequest.this.mUrlResponseInfo.getAllHeaders();
                negotiatedProtocol = JavaUrlRequest.this.mUrlResponseInfo.getNegotiatedProtocol();
                httpStatusCode = JavaUrlRequest.this.mUrlResponseInfo.getHttpStatusCode();
                wasCached = JavaUrlRequest.this.mUrlResponseInfo.wasCached();
            } else {
                responseHeaders = Collections.emptyMap();
                negotiatedProtocol = "";
                httpStatusCode = 0;
                wasCached = false;
            }
            if (wasCached) {
                requestHeaderSizeInBytes = 0L;
                requestBodySizeInBytes = 0L;
            } else {
                requestHeaderSizeInBytes = JavaUrlRequest.estimateHeadersSizeInBytes(JavaUrlRequest.this.mRequestHeaders);
                requestBodySizeInBytes = -1L;
            }
            if (wasCached) {
                responseHeaderSizeInBytes = 0L;
                responseBodySizeInBytes = 0L;
            } else {
                responseHeaderSizeInBytes = JavaUrlRequest.estimateHeadersSizeInBytesList(responseHeaders);
                responseBodySizeInBytes = responseHeaders.containsKey("Content-Length") ? JavaUrlRequest.parseContentLengthString((String)((List)responseHeaders.get("Content-Length")).get(0)) : -1L;
            }
            Duration headersLatency = Duration.ofSeconds(0L);
            Duration totalLatency = Duration.ofSeconds(0L);
            return new CronetLogger.CronetTrafficInfo(requestHeaderSizeInBytes, requestBodySizeInBytes, responseHeaderSizeInBytes, responseBodySizeInBytes, httpStatusCode, headersLatency, totalLatency, negotiatedProtocol, false, false);
        }

        private void maybeReportMetrics() {
            if (Build.VERSION.SDK_INT >= 26) {
                try {
                    JavaUrlRequest.this.mLogger.logCronetTrafficInfo(JavaUrlRequest.this.mCronetEngineId, this.buildCronetTrafficInfo());
                }
                catch (RuntimeException e) {
                    Log.e((String)TAG, (String)"Error while trying to log CronetTrafficInfo: ", (Throwable)e);
                }
            }
        }

        void onCanceled(final UrlResponseInfo info) {
            JavaUrlRequest.this.closeResponseChannel();
            this.mUserExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AsyncUrlRequestCallback.this.mCallback.onCanceled((UrlRequest)JavaUrlRequest.this, info);
                        AsyncUrlRequestCallback.this.maybeReportMetrics();
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)"Exception in onCanceled method", (Throwable)exception);
                    }
                    JavaUrlRequest.this.mEngine.decrementActiveRequestCount();
                }
            });
        }

        void onSucceeded(final UrlResponseInfo info) {
            this.mUserExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AsyncUrlRequestCallback.this.mCallback.onSucceeded((UrlRequest)JavaUrlRequest.this, info);
                        AsyncUrlRequestCallback.this.maybeReportMetrics();
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)"Exception in onSucceeded method", (Throwable)exception);
                    }
                    JavaUrlRequest.this.mEngine.decrementActiveRequestCount();
                }
            });
        }

        void onFailed(final UrlResponseInfo urlResponseInfo, final CronetException e) {
            block2: {
                JavaUrlRequest.this.closeResponseChannel();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AsyncUrlRequestCallback.this.mCallback.onFailed((UrlRequest)JavaUrlRequest.this, urlResponseInfo, e);
                            AsyncUrlRequestCallback.this.maybeReportMetrics();
                        }
                        catch (Exception exception) {
                            Log.e((String)TAG, (String)"Exception in onFailed method", (Throwable)exception);
                        }
                        JavaUrlRequest.this.mEngine.decrementActiveRequestCount();
                    }
                };
                try {
                    this.mUserExecutor.execute(runnable);
                }
                catch (InlineExecutionProhibitedException wasDirect) {
                    if (this.mFallbackExecutor == null) break block2;
                    this.mFallbackExecutor.execute(runnable);
                }
            }
        }
    }

    private static final class SerializingExecutor
    implements Executor {
        private final Executor mUnderlyingExecutor;
        private final Runnable mRunTasks = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Runnable task;
                ArrayDeque<Runnable> arrayDeque = mTaskQueue;
                synchronized (arrayDeque) {
                    if (mRunning) {
                        return;
                    }
                    task = mTaskQueue.pollFirst();
                    mRunning = task != null;
                }
                while (task != null) {
                    ArrayDeque<Runnable> arrayDeque2;
                    boolean threw = true;
                    try {
                        task.run();
                        threw = false;
                        arrayDeque2 = mTaskQueue;
                    }
                    catch (Throwable throwable) {
                        ArrayDeque<Runnable> arrayDeque3 = mTaskQueue;
                        synchronized (arrayDeque3) {
                            if (threw) {
                                mRunning = false;
                                try {
                                    mUnderlyingExecutor.execute(mRunTasks);
                                }
                                catch (RejectedExecutionException rejectedExecutionException) {}
                            } else {
                                task = mTaskQueue.pollFirst();
                                mRunning = task != null;
                            }
                        }
                        throw throwable;
                    }
                    synchronized (arrayDeque2) {
                        if (threw) {
                            mRunning = false;
                            try {
                                mUnderlyingExecutor.execute(mRunTasks);
                            }
                            catch (RejectedExecutionException rejectedExecutionException) {}
                        } else {
                            task = mTaskQueue.pollFirst();
                            mRunning = task != null;
                        }
                    }
                }
            }
        };
        @GuardedBy(value="mTaskQueue")
        private final ArrayDeque<Runnable> mTaskQueue = new ArrayDeque();
        @GuardedBy(value="mTaskQueue")
        private boolean mRunning;

        SerializingExecutor(Executor underlyingExecutor) {
            this.mUnderlyingExecutor = underlyingExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            ArrayDeque<Runnable> arrayDeque = this.mTaskQueue;
            synchronized (arrayDeque) {
                this.mTaskQueue.addLast(command);
                try {
                    this.mUnderlyingExecutor.execute(this.mRunTasks);
                }
                catch (RejectedExecutionException e) {
                    this.mTaskQueue.removeLast();
                }
            }
        }
    }

    private final class OutputStreamDataSink
    extends JavaUploadDataSinkBase {
        private final HttpURLConnection mUrlConnection;
        private final AtomicBoolean mOutputChannelClosed;
        private WritableByteChannel mOutputChannel;
        private OutputStream mUrlConnectionOutputStream;

        OutputStreamDataSink(Executor userExecutor, Executor executor, HttpURLConnection urlConnection, VersionSafeCallbacks.UploadDataProviderWrapper provider) {
            super(userExecutor, executor, (UploadDataProvider)provider);
            this.mOutputChannelClosed = new AtomicBoolean(false);
            this.mUrlConnection = urlConnection;
        }

        protected void initializeRead() throws IOException {
            if (this.mOutputChannel == null) {
                JavaUrlRequest.this.mAdditionalStatusDetails = 10;
                this.mUrlConnection.setDoOutput(true);
                this.mUrlConnection.connect();
                JavaUrlRequest.this.mAdditionalStatusDetails = 12;
                this.mUrlConnectionOutputStream = this.mUrlConnection.getOutputStream();
                this.mOutputChannel = Channels.newChannel(this.mUrlConnectionOutputStream);
            }
        }

        void closeOutputChannel() throws IOException {
            if (this.mOutputChannel != null && this.mOutputChannelClosed.compareAndSet(false, true)) {
                this.mOutputChannel.close();
            }
        }

        protected void finish() throws IOException {
            this.closeOutputChannel();
            JavaUrlRequest.this.fireGetHeaders();
        }

        protected void initializeStart(long totalBytes) {
            if (totalBytes > 0L) {
                this.mUrlConnection.setFixedLengthStreamingMode(totalBytes);
            } else {
                this.mUrlConnection.setChunkedStreamingMode(8192);
            }
        }

        protected int processSuccessfulRead(ByteBuffer buffer) throws IOException {
            int totalBytesProcessed = 0;
            while (buffer.hasRemaining()) {
                totalBytesProcessed += this.mOutputChannel.write(buffer);
            }
            this.mUrlConnectionOutputStream.flush();
            return totalBytesProcessed;
        }

        protected Runnable getErrorSettingRunnable(JavaUrlRequestUtils.CheckedRunnable runnable) {
            return JavaUrlRequest.this.errorSetting(runnable);
        }

        protected Runnable getUploadErrorSettingRunnable(JavaUrlRequestUtils.CheckedRunnable runnable) {
            return JavaUrlRequest.this.uploadErrorSetting(runnable);
        }

        protected void processUploadError(Throwable exception) {
            JavaUrlRequest.this.enterUploadErrorState(exception);
        }
    }
}

