/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.net.http.BidirectionalStream;
import android.net.http.HeaderBlock;
import android.net.http.HttpException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresExtension;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.chromium.net.BidirectionalStream;
import org.chromium.net.CronetException;
import org.chromium.net.UrlResponseInfo;
import org.chromium.net.impl.AndroidBidirectionalStreamWrapper;
import org.chromium.net.impl.AndroidHeaderBlockWrapper;
import org.chromium.net.impl.AndroidUrlResponseInfoWrapper;
import org.chromium.net.impl.CronetExceptionTranslationUtils;

@RequiresExtension(extension=31, version=7)
class AndroidBidirectionalStreamCallbackWrapper
implements BidirectionalStream.Callback {
    private final BidirectionalStream.Callback mBackend;
    private AndroidBidirectionalStreamWrapper mWrappedStream;

    public AndroidBidirectionalStreamCallbackWrapper(BidirectionalStream.Callback backend) {
        this.mBackend = Objects.requireNonNull(backend, "Callback is required.");
    }

    public void onStreamReady(android.net.http.BidirectionalStream bidirectionalStream) {
        this.mBackend.onStreamReady((BidirectionalStream)this.mWrappedStream);
    }

    public void onResponseHeadersReceived(android.net.http.BidirectionalStream bidirectionalStream, android.net.http.UrlResponseInfo urlResponseInfo) {
        AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForBidirectionalStream(urlResponseInfo);
        this.mBackend.onResponseHeadersReceived((BidirectionalStream)this.mWrappedStream, (UrlResponseInfo)specializedResponseInfo);
    }

    public void onReadCompleted(android.net.http.BidirectionalStream bidirectionalStream, android.net.http.UrlResponseInfo urlResponseInfo, ByteBuffer byteBuffer, boolean endOfStream) {
        AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForBidirectionalStream(urlResponseInfo);
        this.mBackend.onReadCompleted((BidirectionalStream)this.mWrappedStream, (UrlResponseInfo)specializedResponseInfo, byteBuffer, endOfStream);
    }

    public void onWriteCompleted(android.net.http.BidirectionalStream bidirectionalStream, android.net.http.UrlResponseInfo urlResponseInfo, ByteBuffer byteBuffer, boolean endOfStream) {
        AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForBidirectionalStream(urlResponseInfo);
        this.mBackend.onWriteCompleted((BidirectionalStream)this.mWrappedStream, (UrlResponseInfo)specializedResponseInfo, byteBuffer, endOfStream);
    }

    public void onResponseTrailersReceived(@NonNull android.net.http.BidirectionalStream bidirectionalStream, @NonNull android.net.http.UrlResponseInfo urlResponseInfo, @NonNull HeaderBlock headerBlock) {
        AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForBidirectionalStream(urlResponseInfo);
        AndroidHeaderBlockWrapper specializedHeaderBlock = new AndroidHeaderBlockWrapper(headerBlock);
        this.mBackend.onResponseTrailersReceived((BidirectionalStream)this.mWrappedStream, (UrlResponseInfo)specializedResponseInfo, (UrlResponseInfo.HeaderBlock)specializedHeaderBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSucceeded(android.net.http.BidirectionalStream bidirectionalStream, android.net.http.UrlResponseInfo urlResponseInfo) {
        AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForBidirectionalStream(urlResponseInfo);
        try {
            this.mBackend.onSucceeded((BidirectionalStream)this.mWrappedStream, (UrlResponseInfo)specializedResponseInfo);
        }
        finally {
            this.mWrappedStream.maybeReportMetrics(0, specializedResponseInfo, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailed(android.net.http.BidirectionalStream bidirectionalStream, android.net.http.UrlResponseInfo urlResponseInfo, HttpException e) {
        AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForBidirectionalStream(urlResponseInfo);
        CronetException exception = CronetExceptionTranslationUtils.translateCheckedAndroidCronetException((Exception)e);
        try {
            this.mBackend.onFailed((BidirectionalStream)this.mWrappedStream, (UrlResponseInfo)specializedResponseInfo, exception);
        }
        finally {
            this.mWrappedStream.maybeReportMetrics(1, specializedResponseInfo, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCanceled(@NonNull android.net.http.BidirectionalStream bidirectionalStream, @Nullable android.net.http.UrlResponseInfo urlResponseInfo) {
        AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForBidirectionalStream(urlResponseInfo);
        try {
            this.mBackend.onCanceled((BidirectionalStream)this.mWrappedStream, (UrlResponseInfo)specializedResponseInfo);
        }
        finally {
            this.mWrappedStream.maybeReportMetrics(2, specializedResponseInfo, null);
        }
    }

    void setStream(AndroidBidirectionalStreamWrapper stream) {
        this.mWrappedStream = stream;
    }
}

