/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.net.http.BidirectionalStream;
import androidx.annotation.RequiresExtension;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.chromium.net.CronetException;
import org.chromium.net.ExperimentalBidirectionalStream;
import org.chromium.net.impl.AndroidBidirectionalStreamCallbackWrapper;
import org.chromium.net.impl.AndroidHttpEngineWrapper;
import org.chromium.net.impl.AndroidRequestFinishedInfoWrapper;
import org.chromium.net.impl.AndroidUrlResponseInfoWrapper;

@RequiresExtension(extension=31, version=7)
class AndroidBidirectionalStreamWrapper
extends ExperimentalBidirectionalStream {
    private final BidirectionalStream mBackend;
    private final AndroidHttpEngineWrapper mEngine;
    private final String mInitialUrl;
    private final Collection<Object> mAnnotations;

    AndroidBidirectionalStreamWrapper(BidirectionalStream backend, AndroidHttpEngineWrapper engine, String url, Collection<Object> annotations) {
        this.mBackend = backend;
        this.mEngine = engine;
        this.mInitialUrl = url;
        this.mAnnotations = annotations;
    }

    static AndroidBidirectionalStreamWrapper createAndAddToCallback(BidirectionalStream backend, AndroidBidirectionalStreamCallbackWrapper callback, AndroidHttpEngineWrapper engine, String url, Collection<Object> annotations) {
        AndroidBidirectionalStreamWrapper wrappedStream = new AndroidBidirectionalStreamWrapper(backend, engine, url, annotations);
        callback.setStream(wrappedStream);
        return wrappedStream;
    }

    public void start() {
        this.mBackend.start();
    }

    public void read(ByteBuffer buffer) {
        this.mBackend.read(buffer);
    }

    public void write(ByteBuffer buffer, boolean endOfStream) {
        this.mBackend.write(buffer, endOfStream);
    }

    public void flush() {
        this.mBackend.flush();
    }

    public void cancel() {
        this.mBackend.cancel();
    }

    public boolean isDone() {
        return this.mBackend.isDone();
    }

    void maybeReportMetrics(int finishedReason, AndroidUrlResponseInfoWrapper responseInfo, CronetException exception) {
        AndroidRequestFinishedInfoWrapper.reportFinished(this.mEngine, this.mInitialUrl, this.mAnnotations, null, finishedReason, responseInfo, exception);
    }
}

