/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.net.http.ConnectionMigrationOptions;
import android.net.http.DnsOptions;
import android.net.http.HttpEngine;
import android.net.http.QuicOptions;
import android.util.Log;
import androidx.annotation.RequiresExtension;
import androidx.annotation.VisibleForTesting;
import java.time.Duration;
import java.util.Date;
import java.util.Set;
import org.chromium.net.CronetEngine;
import org.chromium.net.ExperimentalCronetEngine;
import org.chromium.net.ICronetEngineBuilder;
import org.chromium.net.impl.AndroidHttpEngineWrapper;
import org.chromium.net.telemetry.ExperimentalOptions;
import org.chromium.net.telemetry.OptionalBoolean;

@RequiresExtension(extension=31, version=7)
class AndroidHttpEngineBuilderWrapper
extends ICronetEngineBuilder {
    private static final String TAG = "HttpEngBuilderWrap";
    private static boolean sLibraryLoaderUnsupportedLogged;
    private static boolean sNQEUnsupportedLogged;
    private final HttpEngine.Builder mBackend;

    public AndroidHttpEngineBuilderWrapper(HttpEngine.Builder backend) {
        this.mBackend = backend;
    }

    @VisibleForTesting
    public static ConnectionMigrationOptions parseConnectionMigrationOptions(ExperimentalOptions options) {
        ConnectionMigrationOptions.Builder cmOptionsBuilder = new ConnectionMigrationOptions.Builder();
        cmOptionsBuilder.setDefaultNetworkMigration(AndroidHttpEngineBuilderWrapper.optionalBooleanToMigrationOptionState(options.getMigrateSessionsOnNetworkChangeV2Option()));
        cmOptionsBuilder.setPathDegradationMigration(AndroidHttpEngineBuilderWrapper.optionalBooleanToMigrationOptionState(options.getAllowPortMigration()));
        OptionalBoolean migrateSessionsEarly = options.getMigrateSessionsEarlyV2();
        cmOptionsBuilder.setAllowNonDefaultNetworkUsage(AndroidHttpEngineBuilderWrapper.optionalBooleanToMigrationOptionState(migrateSessionsEarly));
        if (migrateSessionsEarly == OptionalBoolean.TRUE) {
            cmOptionsBuilder.setPathDegradationMigration(AndroidHttpEngineBuilderWrapper.optionalBooleanToMigrationOptionState(OptionalBoolean.TRUE));
        }
        return cmOptionsBuilder.build();
    }

    @VisibleForTesting
    public static DnsOptions parseDnsOptions(ExperimentalOptions options) {
        int expiredDelay;
        DnsOptions.StaleDnsOptions.Builder staleDnsOptionBuilder = new DnsOptions.StaleDnsOptions.Builder();
        int staleDnsDelay = options.getStaleDnsDelayMillisOption();
        if (staleDnsDelay != -1) {
            staleDnsOptionBuilder.setFreshLookupTimeout(Duration.ofMillis(staleDnsDelay));
        }
        if ((expiredDelay = options.getStaleDnsMaxExpiredTimeMillisOption()) != -1) {
            staleDnsOptionBuilder.setMaxExpiredDelay(Duration.ofMillis(expiredDelay));
        }
        staleDnsOptionBuilder.setAllowCrossNetworkUsage(AndroidHttpEngineBuilderWrapper.optionalBooleanToMigrationOptionState(options.getStaleDnsAllowOtherNetworkOption())).setUseStaleOnNameNotResolved(AndroidHttpEngineBuilderWrapper.optionalBooleanToMigrationOptionState(options.getStaleDnsUseStaleOnNameNotResolvedOption()));
        DnsOptions.Builder dnsOptionsBuilder = new DnsOptions.Builder();
        dnsOptionsBuilder.setUseHttpStackDnsResolver(AndroidHttpEngineBuilderWrapper.optionalBooleanToMigrationOptionState(options.getAsyncDnsEnableOption())).setStaleDns(AndroidHttpEngineBuilderWrapper.optionalBooleanToMigrationOptionState(options.getStaleDnsEnableOption())).setStaleDnsOptions(staleDnsOptionBuilder.build()).setPreestablishConnectionsToStaleDnsResults(AndroidHttpEngineBuilderWrapper.optionalBooleanToMigrationOptionState(options.getRaceStaleDnsOnConnection())).setPersistHostCache(AndroidHttpEngineBuilderWrapper.optionalBooleanToMigrationOptionState(options.getStaleDnsPersistToDiskOption()));
        int persistHostCachePeriod = options.getStaleDnsPersistDelayMillisOption();
        if (persistHostCachePeriod != -1) {
            dnsOptionsBuilder.setPersistHostCachePeriod(Duration.ofMillis(persistHostCachePeriod));
        }
        return dnsOptionsBuilder.build();
    }

    @VisibleForTesting
    public static QuicOptions parseQuicOptions(ExperimentalOptions options) {
        int idleConnectionTimeoutSeconds;
        String handshakeUserAgent;
        int inMemoryServerConfigsCacheSize;
        QuicOptions.Builder quicOptionsBuilder = new QuicOptions.Builder();
        if (options.getHostWhitelist() != null) {
            for (String host : options.getHostWhitelist().split(",")) {
                quicOptionsBuilder.addAllowedQuicHost(host);
            }
        }
        if ((inMemoryServerConfigsCacheSize = options.getMaxServerConfigsStoredInPropertiesOption()) != -1) {
            quicOptionsBuilder.setInMemoryServerConfigsCacheSize(inMemoryServerConfigsCacheSize);
        }
        if ((handshakeUserAgent = options.getUserAgentId()) != null) {
            quicOptionsBuilder.setHandshakeUserAgent(handshakeUserAgent);
        }
        if ((idleConnectionTimeoutSeconds = options.getIdleConnectionTimeoutSecondsOption()) != -1) {
            quicOptionsBuilder.setIdleConnectionTimeout(Duration.ofSeconds(idleConnectionTimeoutSeconds));
        }
        return quicOptionsBuilder.build();
    }

    private static int optionalBooleanToMigrationOptionState(OptionalBoolean value) {
        switch (value) {
            case TRUE: {
                return 1;
            }
            case FALSE: {
                return 2;
            }
            case UNSET: {
                return 0;
            }
        }
        throw new AssertionError((Object)("Invalid OptionalBoolean value: " + String.valueOf(value)));
    }

    public String getDefaultUserAgent() {
        return this.mBackend.getDefaultUserAgent();
    }

    public ICronetEngineBuilder setUserAgent(String userAgent) {
        this.mBackend.setUserAgent(userAgent);
        return this;
    }

    public ICronetEngineBuilder setStoragePath(String value) {
        this.mBackend.setStoragePath(value);
        return this;
    }

    public ICronetEngineBuilder setLibraryLoader(CronetEngine.Builder.LibraryLoader loader) {
        if (!sLibraryLoaderUnsupportedLogged) {
            Log.i((String)TAG, (String)"Custom library loader is unsupported when HttpEngineNativeProvider is used.");
            sLibraryLoaderUnsupportedLogged = true;
        }
        return this;
    }

    public ICronetEngineBuilder enableQuic(boolean value) {
        this.mBackend.setEnableQuic(value);
        return this;
    }

    public ICronetEngineBuilder enableSdch(boolean value) {
        return this;
    }

    public ICronetEngineBuilder enableHttp2(boolean value) {
        this.mBackend.setEnableHttp2(value);
        return this;
    }

    public ICronetEngineBuilder enableBrotli(boolean value) {
        this.mBackend.setEnableBrotli(value);
        return this;
    }

    public ICronetEngineBuilder enableHttpCache(int cacheMode, long maxSize) {
        this.mBackend.setEnableHttpCache(cacheMode, maxSize);
        return this;
    }

    public ICronetEngineBuilder addQuicHint(String host, int port, int alternatePort) {
        this.mBackend.addQuicHint(host, port, alternatePort);
        return this;
    }

    public ICronetEngineBuilder addPublicKeyPins(String hostName, Set<byte[]> pinsSha256, boolean includeSubdomains, Date expirationDate) {
        this.mBackend.addPublicKeyPins(hostName, pinsSha256, includeSubdomains, expirationDate.toInstant());
        return this;
    }

    public ICronetEngineBuilder enablePublicKeyPinningBypassForLocalTrustAnchors(boolean value) {
        this.mBackend.setEnablePublicKeyPinningBypassForLocalTrustAnchors(value);
        return this;
    }

    public ICronetEngineBuilder setThreadPriority(int priority) {
        return this;
    }

    public ICronetEngineBuilder setExperimentalOptions(String stringOptions) {
        ExperimentalOptions options = new ExperimentalOptions(stringOptions);
        this.mBackend.setConnectionMigrationOptions(AndroidHttpEngineBuilderWrapper.parseConnectionMigrationOptions(options));
        this.mBackend.setDnsOptions(AndroidHttpEngineBuilderWrapper.parseDnsOptions(options));
        this.mBackend.setQuicOptions(AndroidHttpEngineBuilderWrapper.parseQuicOptions(options));
        return this;
    }

    public ICronetEngineBuilder enableNetworkQualityEstimator(boolean value) {
        if (!sNQEUnsupportedLogged) {
            Log.i((String)TAG, (String)"NetworkQualityEstimator is unsupported when HttpEngineNativeProvider is used");
            sNQEUnsupportedLogged = true;
        }
        return this;
    }

    public ExperimentalCronetEngine build() {
        return new AndroidHttpEngineWrapper(this.mBackend.build());
    }
}

