/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.net.Network;
import android.net.http.BidirectionalStream;
import android.net.http.HttpEngine;
import android.net.http.UrlRequest;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresExtension;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.chromium.net.BidirectionalStream;
import org.chromium.net.ExperimentalBidirectionalStream;
import org.chromium.net.ExperimentalUrlRequest;
import org.chromium.net.RequestFinishedInfo;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UrlRequest;
import org.chromium.net.impl.AndroidBidirectionalStreamCallbackWrapper;
import org.chromium.net.impl.AndroidBidirectionalStreamWrapper;
import org.chromium.net.impl.AndroidUploadDataProviderWrapper;
import org.chromium.net.impl.AndroidUrlRequestCallbackWrapper;
import org.chromium.net.impl.AndroidUrlRequestWrapper;
import org.chromium.net.impl.BidirectionalStreamBuilderImpl;
import org.chromium.net.impl.CronetEngineBase;
import org.chromium.net.impl.CronetExceptionTranslationUtils;
import org.chromium.net.impl.VersionSafeCallbacks;

@RequiresExtension(extension=31, version=7)
class AndroidHttpEngineWrapper
extends CronetEngineBase {
    private static final String TAG = "HttpEngineWrapper";
    private static boolean sNetlogUnsupportedLogged;
    private static boolean sGlobalMetricsUnsupportedLogged;
    private final HttpEngine mBackend;
    private final Map<RequestFinishedInfo.Listener, VersionSafeCallbacks.RequestFinishedInfoListener> mFinishedListenerMap = Collections.synchronizedMap(new HashMap());

    public AndroidHttpEngineWrapper(HttpEngine backend) {
        this.mBackend = backend;
    }

    private Network getNetwork(long networkHandle) {
        return networkHandle == -1L ? null : Network.fromNetworkHandle((long)networkHandle);
    }

    public String getVersionString() {
        return HttpEngine.getVersionString();
    }

    public void shutdown() {
        this.mBackend.shutdown();
    }

    public void startNetLogToFile(String fileName, boolean logAll) {
        if (!sNetlogUnsupportedLogged) {
            Log.i((String)TAG, (String)"Netlog is unsupported when HttpEngineNativeProvider is used.");
            sNetlogUnsupportedLogged = true;
        }
    }

    public void stopNetLog() {
    }

    public byte[] getGlobalMetricsDeltas() {
        if (!sGlobalMetricsUnsupportedLogged) {
            Log.i((String)TAG, (String)"GlobalMetricsDelta is unsupported when HttpEngineNativeProvider is used. An empty protobuf is returned.");
            sGlobalMetricsUnsupportedLogged = true;
        }
        return new byte[0];
    }

    public void bindToNetwork(long networkHandle) {
        this.mBackend.bindToNetwork(this.getNetwork(networkHandle));
    }

    public URLConnection openConnection(URL url) throws IOException {
        return CronetExceptionTranslationUtils.executeTranslatingCronetExceptions(() -> this.mBackend.openConnection(url), IOException.class);
    }

    public URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        if (proxy.type() != Proxy.Type.DIRECT) {
            throw new UnsupportedOperationException();
        }
        String protocol = url.getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            return this.openConnection(url);
        }
        throw new UnsupportedOperationException("Unexpected protocol:" + protocol);
    }

    public URLStreamHandlerFactory createURLStreamHandlerFactory() {
        return this.mBackend.createUrlStreamHandlerFactory();
    }

    public ExperimentalBidirectionalStream.Builder newBidirectionalStreamBuilder(String url, BidirectionalStream.Callback callback, Executor executor) {
        return new BidirectionalStreamBuilderImpl(url, callback, executor, (CronetEngineBase)this);
    }

    public void addRequestFinishedListener(RequestFinishedInfo.Listener listener) {
        this.mFinishedListenerMap.put(listener, new VersionSafeCallbacks.RequestFinishedInfoListener(listener));
    }

    public void removeRequestFinishedListener(RequestFinishedInfo.Listener listener) {
        this.mFinishedListenerMap.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportRequestFinished(RequestFinishedInfo requestInfo, VersionSafeCallbacks.RequestFinishedInfoListener extraRequestListener) {
        ArrayList<VersionSafeCallbacks.RequestFinishedInfoListener> currentListeners = new ArrayList<VersionSafeCallbacks.RequestFinishedInfoListener>();
        Map<RequestFinishedInfo.Listener, VersionSafeCallbacks.RequestFinishedInfoListener> map = this.mFinishedListenerMap;
        synchronized (map) {
            currentListeners.addAll(this.mFinishedListenerMap.values());
        }
        if (extraRequestListener != null) {
            currentListeners.add(extraRequestListener);
        }
        for (VersionSafeCallbacks.RequestFinishedInfoListener listener : currentListeners) {
            try {
                listener.getExecutor().execute(() -> {
                    try {
                        listener.onRequestFinished(requestInfo);
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"Exception thrown from observation task", (Throwable)e);
                    }
                });
            }
            catch (RejectedExecutionException failException) {
                Log.e((String)TAG, (String)"Exception posting task to executor", (Throwable)failException);
            }
        }
    }

    public ExperimentalBidirectionalStream createBidirectionalStream(String url, BidirectionalStream.Callback callback, Executor executor, String httpMethod, List<Map.Entry<String, String>> requestHeaders, int priority, boolean delayRequestHeadersUntilFirstFlush, Collection<Object> requestAnnotations, boolean trafficStatsTagSet, int trafficStatsTag, boolean trafficStatsUidSet, int trafficStatsUid, long networkHandle) {
        AndroidBidirectionalStreamCallbackWrapper wrappedCallback = new AndroidBidirectionalStreamCallbackWrapper(callback);
        BidirectionalStream.Builder streamBuilder = this.mBackend.newBidirectionalStreamBuilder(url, executor, (BidirectionalStream.Callback)wrappedCallback);
        streamBuilder.setHttpMethod(httpMethod);
        for (Map.Entry<String, String> header : requestHeaders) {
            streamBuilder.addHeader(header.getKey(), header.getValue());
        }
        streamBuilder.setPriority(priority);
        streamBuilder.setDelayRequestHeadersUntilFirstFlushEnabled(delayRequestHeadersUntilFirstFlush);
        if (trafficStatsTagSet) {
            streamBuilder.setTrafficStatsTag(trafficStatsTag);
        }
        if (trafficStatsUidSet) {
            streamBuilder.setTrafficStatsUid(trafficStatsUid);
        }
        return AndroidBidirectionalStreamWrapper.createAndAddToCallback(streamBuilder.build(), wrappedCallback, this, url, requestAnnotations);
    }

    public ExperimentalUrlRequest createRequest(String url, UrlRequest.Callback callback, Executor executor, int priority, Collection<Object> requestAnnotations, boolean disableCache, boolean disableConnectionMigration, boolean allowDirectExecutor, boolean trafficStatsTagSet, int trafficStatsTag, boolean trafficStatsUidSet, int trafficStatsUid, @Nullable RequestFinishedInfo.Listener requestFinishedListener, int idempotency, long networkHandle, String method, ArrayList<Map.Entry<String, String>> requestHeaders, UploadDataProvider uploadDataProvider, Executor uploadDataProviderExecutor, byte[] dictionarySha256Hash, ByteBuffer sharedDictionary, @NonNull String sharedDictionaryId) {
        AndroidUrlRequestCallbackWrapper wrappedCallback = new AndroidUrlRequestCallbackWrapper(callback);
        UrlRequest.Builder requestBuilder = this.mBackend.newUrlRequestBuilder(url, executor, (UrlRequest.Callback)wrappedCallback);
        requestBuilder.setPriority(priority);
        if (disableCache) {
            requestBuilder.setCacheDisabled(disableCache);
        }
        if (allowDirectExecutor) {
            requestBuilder.setDirectExecutorAllowed(allowDirectExecutor);
        }
        if (trafficStatsTagSet) {
            requestBuilder.setTrafficStatsTag(trafficStatsTag);
        }
        if (trafficStatsUidSet) {
            requestBuilder.setTrafficStatsTag(trafficStatsUid);
        }
        requestBuilder.bindToNetwork(this.getNetwork(networkHandle));
        requestBuilder.setHttpMethod(method);
        for (Map.Entry<String, String> header : requestHeaders) {
            requestBuilder.addHeader(header.getKey(), header.getValue());
        }
        if (uploadDataProvider != null) {
            requestBuilder.setUploadDataProvider((android.net.http.UploadDataProvider)new AndroidUploadDataProviderWrapper(uploadDataProvider), uploadDataProviderExecutor);
        }
        return AndroidUrlRequestWrapper.createAndAddToCallback(requestBuilder.build(), wrappedCallback, this, url, requestAnnotations, requestFinishedListener);
    }
}

