/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.net.http.QuicException;
import androidx.annotation.RequiresExtension;
import org.chromium.net.NetworkException;

@RequiresExtension(extension=31, version=7)
class AndroidNetworkExceptionWrapper
extends NetworkException {
    private final android.net.http.NetworkException mBackend;

    AndroidNetworkExceptionWrapper(android.net.http.NetworkException backend) {
        this(backend, false);
    }

    AndroidNetworkExceptionWrapper(android.net.http.NetworkException backend, boolean expectQuicException) {
        super(backend.getMessage(), (Throwable)backend);
        this.mBackend = backend;
        if (!expectQuicException && backend instanceof QuicException) {
            throw new IllegalArgumentException("Translating QuicException as NetworkException results in loss of information. Make sure you handle QuicException first. See the stacktrace for where the translation is being performed, and the cause for the exception being translated.", (Throwable)backend);
        }
    }

    public int getErrorCode() {
        return this.mBackend.getErrorCode();
    }

    public int getCronetInternalErrorCode() {
        return -1;
    }

    public boolean immediatelyRetryable() {
        return this.mBackend.isImmediatelyRetryable();
    }
}

