/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.net.http.NetworkException;
import androidx.annotation.RequiresExtension;
import org.chromium.net.QuicException;
import org.chromium.net.impl.AndroidNetworkExceptionWrapper;

@RequiresExtension(extension=31, version=7)
class AndroidQuicExceptionWrapper
extends QuicException {
    private final AndroidNetworkExceptionWrapper mBackend;

    AndroidQuicExceptionWrapper(android.net.http.QuicException backend) {
        super(backend.getMessage(), (Throwable)backend);
        this.mBackend = new AndroidNetworkExceptionWrapper((NetworkException)backend, true);
    }

    public int getQuicDetailedErrorCode() {
        return 0;
    }

    public int getErrorCode() {
        return this.mBackend.getErrorCode();
    }

    public int getCronetInternalErrorCode() {
        return this.mBackend.getCronetInternalErrorCode();
    }

    public boolean immediatelyRetryable() {
        return this.mBackend.immediatelyRetryable();
    }

    public int getConnectionCloseSource() {
        return 0;
    }
}

