/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresExtension;
import java.util.Collection;
import org.chromium.net.CronetException;
import org.chromium.net.RequestFinishedInfo;
import org.chromium.net.UrlResponseInfo;
import org.chromium.net.impl.AndroidHttpEngineWrapper;
import org.chromium.net.impl.CronetMetrics;
import org.chromium.net.impl.RequestFinishedInfoImpl;
import org.chromium.net.impl.VersionSafeCallbacks;

@RequiresExtension(extension=31, version=7)
class AndroidRequestFinishedInfoWrapper
extends RequestFinishedInfoImpl {
    private static final String TAG = RequestFinishedInfoImpl.class.getSimpleName();
    private static boolean sListenerSupportLimitedLogged;

    private AndroidRequestFinishedInfoWrapper(String url, Collection<Object> annotations, RequestFinishedInfo.Metrics metrics, int finishedReason, @Nullable UrlResponseInfo responseInfo, @Nullable CronetException exception) {
        super(url, annotations, metrics, finishedReason, responseInfo, exception);
    }

    static void reportFinished(AndroidHttpEngineWrapper engine, String url, Collection<Object> annotations, VersionSafeCallbacks.RequestFinishedInfoListener listener, int finishedReason, UrlResponseInfo responseInfo, CronetException exception) {
        AndroidRequestFinishedInfoWrapper requestInfo = new AndroidRequestFinishedInfoWrapper(url, annotations, (RequestFinishedInfo.Metrics)new CronetMetrics(-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, false, -1L, -1L), finishedReason, responseInfo, exception);
        engine.reportRequestFinished((RequestFinishedInfo)requestInfo, listener);
    }

    public RequestFinishedInfo.Metrics getMetrics() {
        if (!sListenerSupportLimitedLogged) {
            Log.i((String)TAG, (String)"RequestFinishedInfo.getMetrics() is unsupported when HttpEngineNativeProvider is used. The Metrics object will return null values.");
            sListenerSupportLimitedLogged = true;
        }
        return super.getMetrics();
    }
}

