/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import androidx.annotation.RequiresExtension;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.chromium.net.UploadDataProvider;
import org.chromium.net.UploadDataSink;
import org.chromium.net.impl.AndroidUploadDataSinkWrapper;

@RequiresExtension(extension=31, version=7)
class AndroidUploadDataProviderWrapper
extends android.net.http.UploadDataProvider {
    private final UploadDataProvider mBackend;

    public AndroidUploadDataProviderWrapper(UploadDataProvider backend) {
        this.mBackend = Objects.requireNonNull(backend, "Invalid UploadDataProvider.");
    }

    public long getLength() throws IOException {
        return this.mBackend.getLength();
    }

    public void read(android.net.http.UploadDataSink uploadDataSink, ByteBuffer byteBuffer) throws IOException {
        AndroidUploadDataSinkWrapper wrapper = new AndroidUploadDataSinkWrapper(uploadDataSink);
        this.mBackend.read((UploadDataSink)wrapper, byteBuffer);
    }

    public void rewind(android.net.http.UploadDataSink uploadDataSink) throws IOException {
        AndroidUploadDataSinkWrapper wrapper = new AndroidUploadDataSinkWrapper(uploadDataSink);
        this.mBackend.rewind((UploadDataSink)wrapper);
    }

    public void close() throws IOException {
        this.mBackend.close();
    }
}

