/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.net.http.HttpException;
import android.net.http.UrlRequest;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresExtension;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.chromium.net.CronetException;
import org.chromium.net.UrlRequest;
import org.chromium.net.UrlResponseInfo;
import org.chromium.net.impl.AndroidUrlRequestWrapper;
import org.chromium.net.impl.AndroidUrlResponseInfoWrapper;
import org.chromium.net.impl.CronetExceptionTranslationUtils;

@RequiresExtension(extension=31, version=7)
class AndroidUrlRequestCallbackWrapper
implements UrlRequest.Callback {
    private final UrlRequest.Callback mBackend;
    private AndroidUrlRequestWrapper mWrappedRequest;

    public AndroidUrlRequestCallbackWrapper(UrlRequest.Callback backend) {
        this.mBackend = Objects.requireNonNull(backend, "Callback is required.");
    }

    public void onRedirectReceived(android.net.http.UrlRequest request, android.net.http.UrlResponseInfo info, String newLocationUrl) throws Exception {
        CronetExceptionTranslationUtils.executeTranslatingCronetExceptions(() -> {
            AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForUrlRequest(info);
            this.mBackend.onRedirectReceived((UrlRequest)this.mWrappedRequest, (UrlResponseInfo)specializedResponseInfo, newLocationUrl);
            return null;
        }, Exception.class);
    }

    public void onResponseStarted(android.net.http.UrlRequest request, android.net.http.UrlResponseInfo info) throws Exception {
        CronetExceptionTranslationUtils.executeTranslatingCronetExceptions(() -> {
            AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForUrlRequest(info);
            this.mBackend.onResponseStarted((UrlRequest)this.mWrappedRequest, (UrlResponseInfo)specializedResponseInfo);
            return null;
        }, Exception.class);
    }

    public void onReadCompleted(android.net.http.UrlRequest request, android.net.http.UrlResponseInfo info, ByteBuffer byteBuffer) throws Exception {
        CronetExceptionTranslationUtils.executeTranslatingCronetExceptions(() -> {
            AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForUrlRequest(info);
            this.mBackend.onReadCompleted((UrlRequest)this.mWrappedRequest, (UrlResponseInfo)specializedResponseInfo, byteBuffer);
            return null;
        }, Exception.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSucceeded(android.net.http.UrlRequest request, android.net.http.UrlResponseInfo info) {
        AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForUrlRequest(info);
        try {
            this.mBackend.onSucceeded((UrlRequest)this.mWrappedRequest, (UrlResponseInfo)specializedResponseInfo);
        }
        finally {
            this.mWrappedRequest.maybeReportMetrics(0, specializedResponseInfo, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailed(android.net.http.UrlRequest request, android.net.http.UrlResponseInfo info, HttpException error) {
        AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForUrlRequest(info);
        CronetException translatedException = CronetExceptionTranslationUtils.translateCheckedAndroidCronetException((Exception)error);
        try {
            this.mBackend.onFailed((UrlRequest)this.mWrappedRequest, (UrlResponseInfo)specializedResponseInfo, translatedException);
        }
        finally {
            this.mWrappedRequest.maybeReportMetrics(1, specializedResponseInfo, translatedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCanceled(@NonNull android.net.http.UrlRequest request, @Nullable android.net.http.UrlResponseInfo info) {
        AndroidUrlResponseInfoWrapper specializedResponseInfo = AndroidUrlResponseInfoWrapper.createForUrlRequest(info);
        try {
            this.mBackend.onCanceled((UrlRequest)this.mWrappedRequest, (UrlResponseInfo)specializedResponseInfo);
        }
        finally {
            this.mWrappedRequest.maybeReportMetrics(2, specializedResponseInfo, null);
        }
    }

    void setRequest(AndroidUrlRequestWrapper request) {
        this.mWrappedRequest = request;
    }
}

