/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.net.http.UrlRequest;
import androidx.annotation.RequiresExtension;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.chromium.net.CronetException;
import org.chromium.net.ExperimentalUrlRequest;
import org.chromium.net.RequestFinishedInfo;
import org.chromium.net.UrlRequest;
import org.chromium.net.impl.AndroidHttpEngineWrapper;
import org.chromium.net.impl.AndroidRequestFinishedInfoWrapper;
import org.chromium.net.impl.AndroidUrlRequestCallbackWrapper;
import org.chromium.net.impl.AndroidUrlRequestStatusListenerWrapper;
import org.chromium.net.impl.AndroidUrlResponseInfoWrapper;
import org.chromium.net.impl.VersionSafeCallbacks;

@RequiresExtension(extension=31, version=7)
class AndroidUrlRequestWrapper
extends ExperimentalUrlRequest {
    private final UrlRequest mBackend;
    private final AndroidHttpEngineWrapper mEngine;
    private final String mInitialUrl;
    private final Collection<Object> mAnnotations;
    private final VersionSafeCallbacks.RequestFinishedInfoListener mRequestFinishedInfoListener;

    AndroidUrlRequestWrapper(UrlRequest backend, AndroidHttpEngineWrapper engine, String url, Collection<Object> annotations, RequestFinishedInfo.Listener requestFinishedInfoListener) {
        this.mBackend = backend;
        this.mEngine = engine;
        this.mInitialUrl = url;
        this.mAnnotations = annotations;
        this.mRequestFinishedInfoListener = requestFinishedInfoListener == null ? null : new VersionSafeCallbacks.RequestFinishedInfoListener(requestFinishedInfoListener);
    }

    static AndroidUrlRequestWrapper createAndAddToCallback(UrlRequest backend, AndroidUrlRequestCallbackWrapper callback, AndroidHttpEngineWrapper engine, String url, Collection<Object> annotations, RequestFinishedInfo.Listener requestFinishedInfoListener) {
        AndroidUrlRequestWrapper wrappedRequest = new AndroidUrlRequestWrapper(backend, engine, url, annotations, requestFinishedInfoListener);
        callback.setRequest(wrappedRequest);
        return wrappedRequest;
    }

    public void start() {
        this.mBackend.start();
    }

    public void followRedirect() {
        this.mBackend.followRedirect();
    }

    public void read(ByteBuffer buffer) {
        this.mBackend.read(buffer);
    }

    public void cancel() {
        this.mBackend.cancel();
    }

    public boolean isDone() {
        return this.mBackend.isDone();
    }

    public void getStatus(UrlRequest.StatusListener listener) {
        this.mBackend.getStatus((UrlRequest.StatusListener)new AndroidUrlRequestStatusListenerWrapper(listener));
    }

    void maybeReportMetrics(int finishedReason, AndroidUrlResponseInfoWrapper responseInfo, CronetException exception) {
        AndroidRequestFinishedInfoWrapper.reportFinished(this.mEngine, this.mInitialUrl, this.mAnnotations, this.mRequestFinishedInfoListener, finishedReason, responseInfo, exception);
    }
}

