/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import androidx.annotation.RequiresExtension;
import java.util.List;
import java.util.Map;
import org.chromium.net.UrlResponseInfo;

@RequiresExtension(extension=31, version=7)
class AndroidUrlResponseInfoWrapper
extends UrlResponseInfo {
    private final android.net.http.UrlResponseInfo mBackend;
    private final String mProxyServerCompat;

    private AndroidUrlResponseInfoWrapper(android.net.http.UrlResponseInfo backend, String proxyServerCompat) {
        this.mBackend = backend;
        this.mProxyServerCompat = proxyServerCompat;
    }

    public static AndroidUrlResponseInfoWrapper createForUrlRequest(android.net.http.UrlResponseInfo backend) {
        return AndroidUrlResponseInfoWrapper.isResponseInfoNull(backend) ? null : new AndroidUrlResponseInfoWrapper(backend, ":0");
    }

    public static AndroidUrlResponseInfoWrapper createForBidirectionalStream(android.net.http.UrlResponseInfo backend) {
        return AndroidUrlResponseInfoWrapper.isResponseInfoNull(backend) ? null : new AndroidUrlResponseInfoWrapper(backend, null);
    }

    private static boolean isResponseInfoNull(android.net.http.UrlResponseInfo backend) {
        if (backend == null) {
            return true;
        }
        try {
            backend.getUrl();
        }
        catch (NullPointerException e) {
            return true;
        }
        return false;
    }

    public String getUrl() {
        return this.mBackend.getUrl();
    }

    public List<String> getUrlChain() {
        return this.mBackend.getUrlChain();
    }

    public int getHttpStatusCode() {
        return this.mBackend.getHttpStatusCode();
    }

    public String getHttpStatusText() {
        return this.mBackend.getHttpStatusText();
    }

    public List<Map.Entry<String, String>> getAllHeadersAsList() {
        return this.mBackend.getHeaders().getAsList();
    }

    public Map<String, List<String>> getAllHeaders() {
        return this.mBackend.getHeaders().getAsMap();
    }

    public boolean wasCached() {
        return this.mBackend.wasCached();
    }

    public String getNegotiatedProtocol() {
        return this.mBackend.getNegotiatedProtocol();
    }

    public String getProxyServer() {
        return this.mProxyServerCompat;
    }

    public long getReceivedByteCount() {
        return this.mBackend.getReceivedByteCount();
    }
}

