/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.net.http.CallbackException;
import android.net.http.HttpException;
import android.net.http.NetworkException;
import android.net.http.QuicException;
import androidx.annotation.RequiresExtension;
import org.chromium.net.CronetException;
import org.chromium.net.InlineExecutionProhibitedException;
import org.chromium.net.impl.AndroidCallbackExceptionWrapper;
import org.chromium.net.impl.AndroidHttpExceptionWrapper;
import org.chromium.net.impl.AndroidNetworkExceptionWrapper;
import org.chromium.net.impl.AndroidQuicExceptionWrapper;

@RequiresExtension(extension=31, version=7)
class CronetExceptionTranslationUtils {
    public static <T, E extends Exception> T executeTranslatingCronetExceptions(CronetWork<T, E> work, Class<E> nonCronetException) throws CronetException, E {
        try {
            return work.run();
        }
        catch (Exception e) {
            if (CronetExceptionTranslationUtils.isUncheckedAndroidCronetException(e)) {
                throw CronetExceptionTranslationUtils.translateUncheckedAndroidCronetException(e);
            }
            if (CronetExceptionTranslationUtils.isCheckedAndroidCronetException(e)) {
                throw CronetExceptionTranslationUtils.translateCheckedAndroidCronetException(e);
            }
            if (nonCronetException.isInstance(e)) {
                throw e;
            }
            throw e;
        }
    }

    public static boolean isUncheckedAndroidCronetException(Exception e) {
        return e instanceof android.net.http.InlineExecutionProhibitedException;
    }

    public static boolean isCheckedAndroidCronetException(Exception e) {
        return e instanceof HttpException;
    }

    public static RuntimeException translateUncheckedAndroidCronetException(Exception e) {
        if (!CronetExceptionTranslationUtils.isUncheckedAndroidCronetException(e)) {
            throw new IllegalArgumentException("Not an Android Cronet exception", e);
        }
        if (e instanceof android.net.http.InlineExecutionProhibitedException) {
            InlineExecutionProhibitedException wrappedException = new InlineExecutionProhibitedException();
            wrappedException.initCause((Throwable)e);
            return wrappedException;
        }
        throw new UnsupportedOperationException("Unchecked exception translation discrepancy", e);
    }

    public static CronetException translateCheckedAndroidCronetException(Exception e) {
        if (!CronetExceptionTranslationUtils.isCheckedAndroidCronetException(e)) {
            throw new IllegalArgumentException("Not an Android Cronet exception", e);
        }
        if (e instanceof QuicException) {
            return new AndroidQuicExceptionWrapper((QuicException)e);
        }
        if (e instanceof NetworkException) {
            return new AndroidNetworkExceptionWrapper((NetworkException)e);
        }
        if (e instanceof CallbackException) {
            return new AndroidCallbackExceptionWrapper((CallbackException)e);
        }
        if (e instanceof HttpException) {
            return new AndroidHttpExceptionWrapper((HttpException)e);
        }
        throw new UnsupportedOperationException("Checked exception translation discrepancy", e);
    }

    private CronetExceptionTranslationUtils() {
    }

    static interface CronetWork<T, E extends Exception> {
        public T run() throws E;
    }
}

