/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net.impl;

import android.content.Context;
import android.net.http.HttpEngine;
import android.os.Build;
import android.os.ext.SdkExtensions;
import androidx.annotation.RequiresExtension;
import org.chromium.base.metrics.ScopedSysTraceEvent;
import org.chromium.net.CronetEngine;
import org.chromium.net.CronetProvider;
import org.chromium.net.ExperimentalCronetEngine;
import org.chromium.net.ICronetEngineBuilder;
import org.chromium.net.impl.AndroidHttpEngineBuilderWrapper;

public class HttpEngineNativeProvider
extends CronetProvider {
    public static final String PROVIDER_NAME_HTTPENGINE_NATIVE = "HttpEngine-Native-Provider";
    static final int EXT_API_LEVEL = 31;
    static final int EXT_VERSION = 7;

    public HttpEngineNativeProvider(Context context) {
        super(context);
    }

    static boolean isHttpEngineAvailable() {
        return Build.VERSION.SDK_INT >= 30 && SdkExtensions.getExtensionVersion((int)31) >= 7;
    }

    @RequiresExtension(extension=31, version=7)
    public CronetEngine.Builder createBuilder() {
        try (ScopedSysTraceEvent traceEvent = ScopedSysTraceEvent.scoped((String)"HttpEngineNativeProvider#createBuilder");){
            ExperimentalCronetEngine.Builder builder = new ExperimentalCronetEngine.Builder((ICronetEngineBuilder)new AndroidHttpEngineBuilderWrapper(new HttpEngine.Builder(this.mContext)));
            return builder;
        }
    }

    public String getName() {
        return PROVIDER_NAME_HTTPENGINE_NATIVE;
    }

    @RequiresExtension(extension=31, version=7)
    public String getVersion() {
        return HttpEngine.getVersionString();
    }

    public boolean isEnabled() {
        return HttpEngineNativeProvider.isHttpEngineAvailable();
    }
}

