/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.completers;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.spi.Completer;
import org.crsh.cli.spi.Completion;
import org.crsh.cli.type.ValueType;

public class ObjectNameCompleter
implements Completer {
    private static String[] parseKeyValue(String s) {
        int eq = s.indexOf(61);
        if (eq == -1) {
            return new String[]{s, null};
        }
        return new String[]{s.substring(0, eq), s.substring(eq + 1, s.length())};
    }

    @Override
    public Completion complete(ParameterDescriptor parameter, String prefix) throws Exception {
        if (parameter.getType() == ValueType.OBJECT_NAME) {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            int colon = prefix.indexOf(58);
            if (colon == -1) {
                Completion.Builder b = new Completion.Builder(prefix);
                LinkedHashSet<String> domains = new LinkedHashSet<String>();
                for (ObjectName name : server.queryNames(null, null)) {
                    domains.add(name.getDomain());
                }
                for (String domain : domains) {
                    if (!domain.startsWith(prefix)) continue;
                    b.add(domain.substring(prefix.length()) + ":", false);
                }
                return b.build();
            }
            String domain = prefix.substring(0, colon);
            String rest = prefix.substring(colon + 1);
            int prev = 0;
            Hashtable<String, String> keyValues = new Hashtable<String, String>();
            while (true) {
                String[] keyValue;
                int next;
                if ((next = rest.indexOf(44, prev)) == -1) {
                    Completion.Builder b;
                    keyValue = ObjectNameCompleter.parseKeyValue(rest.substring(prev));
                    HashSet<ObjectName> completions = new HashSet<ObjectName>();
                    for (ObjectName name : server.queryNames(null, null)) {
                        if (!name.getDomain().equals(domain) || !name.getKeyPropertyList().entrySet().containsAll(keyValues.entrySet())) continue;
                        completions.add(name);
                    }
                    if (keyValue[1] == null) {
                        b = new Completion.Builder(keyValue[0]);
                        for (ObjectName name : completions) {
                            for (String key : name.getKeyPropertyList().keySet()) {
                                if (keyValues.containsKey(key) || !key.startsWith(keyValue[0])) continue;
                                b.add(key.substring(keyValue[0].length()) + "=", false);
                            }
                        }
                        return b.build();
                    }
                    b = new Completion.Builder(keyValue[1]);
                    for (ObjectName completion : completions) {
                        String value = completion.getKeyProperty(keyValue[0]);
                        if (value == null || !value.startsWith(keyValue[1])) continue;
                        Hashtable<String, String> a = completion.getKeyPropertyList();
                        a.remove(keyValue[0]);
                        a.keySet().removeAll(keyValues.keySet());
                        if (a.isEmpty()) {
                            b.add(value.substring(keyValue[1].length()), true);
                            continue;
                        }
                        b.add(value.substring(keyValue[1].length()) + ",", false);
                    }
                    return b.build();
                }
                keyValue = ObjectNameCompleter.parseKeyValue(rest.substring(prev, next));
                keyValues.put(keyValue[0], keyValue[1]);
                prev = next + 1;
            }
        }
        return Completion.create();
    }
}

