/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.database;

import android.content.Context;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteOpenHelper;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseOpenHelper;
import org.greenrobot.greendao.database.EncryptedDatabase;

class SqlCipherEncryptedHelper
extends SQLiteOpenHelper
implements DatabaseOpenHelper.EncryptedHelper {
    private final DatabaseOpenHelper delegate;

    public SqlCipherEncryptedHelper(DatabaseOpenHelper delegate, Context context, String name, int version, boolean loadLibs) {
        super(context, name, null, version);
        this.delegate = delegate;
        if (loadLibs) {
            SQLiteDatabase.loadLibs((Context)context);
        }
    }

    private Database wrap(SQLiteDatabase sqLiteDatabase) {
        return new EncryptedDatabase(sqLiteDatabase);
    }

    public void onCreate(SQLiteDatabase db) {
        this.delegate.onCreate(this.wrap(db));
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.delegate.onUpgrade(this.wrap(db), oldVersion, newVersion);
    }

    public void onOpen(SQLiteDatabase db) {
        this.delegate.onOpen(this.wrap(db));
    }

    @Override
    public Database getEncryptedReadableDb(String password) {
        return this.wrap(this.getReadableDatabase(password));
    }

    @Override
    public Database getEncryptedReadableDb(char[] password) {
        return this.wrap(this.getReadableDatabase(password));
    }

    @Override
    public Database getEncryptedWritableDb(String password) {
        return this.wrap(this.getWritableDatabase(password));
    }

    @Override
    public Database getEncryptedWritableDb(char[] password) {
        return this.wrap(this.getWritableDatabase(password));
    }
}

