/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.expressions;

import java.util.Arrays;
import org.greenrobot.eclipse.core.expressions.EvaluationContext;
import org.greenrobot.eclipse.core.expressions.EvaluationResult;
import org.greenrobot.eclipse.core.expressions.ExpressionInfo;
import org.greenrobot.eclipse.core.expressions.IEvaluationContext;
import org.greenrobot.eclipse.core.internal.expressions.CompositeExpression;
import org.greenrobot.eclipse.core.internal.expressions.ExpressionMessages;
import org.greenrobot.eclipse.core.internal.expressions.ExpressionStatus;
import org.greenrobot.eclipse.core.internal.expressions.Expressions;
import org.greenrobot.eclipse.core.internal.expressions.Messages;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;

public class ResolveExpression
extends CompositeExpression {
    private String fVariable;
    private Object[] fArgs;
    private static final String ATT_VARIABLE = "variable";
    private static final String ATT_ARGS = "args";
    private static final int HASH_INITIAL = ResolveExpression.class.getName().hashCode();

    public ResolveExpression(IConfigurationElement configElement) throws CoreException {
        this.fVariable = configElement.getAttribute(ATT_VARIABLE);
        Expressions.checkAttribute(ATT_VARIABLE, this.fVariable);
        this.fArgs = Expressions.getArguments(configElement, ATT_ARGS);
    }

    public ResolveExpression(Element element) throws CoreException {
        this.fVariable = element.getAttribute(ATT_VARIABLE);
        Expressions.checkAttribute(ATT_VARIABLE, this.fVariable.isEmpty() ? null : this.fVariable);
        this.fArgs = Expressions.getArguments(element, ATT_ARGS);
    }

    public ResolveExpression(String variable, Object[] args) {
        Assert.isNotNull(variable);
        this.fVariable = variable;
        this.fArgs = args;
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        Object variable = context.resolveVariable(this.fVariable, this.fArgs);
        if (variable == null) {
            throw new CoreException(new ExpressionStatus(301, Messages.format(ExpressionMessages.ResolveExpression_variable_not_defined, this.fVariable)));
        }
        return this.evaluateAnd(new EvaluationContext(context, variable));
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        ExpressionInfo other = new ExpressionInfo();
        super.collectExpressionInfo(other);
        if (other.hasDefaultVariableAccess()) {
            info.addVariableNameAccess(this.fVariable);
        }
        info.mergeExceptDefaultVariable(other);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ResolveExpression)) {
            return false;
        }
        ResolveExpression that = (ResolveExpression)object;
        return this.fVariable.equals(that.fVariable) && ResolveExpression.equals(this.fArgs, that.fArgs) && ResolveExpression.equals(this.fExpressions, that.fExpressions);
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + ResolveExpression.hashCode(this.fExpressions) * 89 + ResolveExpression.hashCode(this.fArgs) * 89 + this.fVariable.hashCode();
    }

    @Override
    public String toString() {
        Object[] children;
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [variable=").append(this.fVariable);
        if (this.fArgs != null) {
            builder.append(", args=").append(Arrays.toString(this.fArgs));
        }
        if ((children = this.getChildren()).length > 0) {
            builder.append(", children=");
            builder.append(Arrays.toString(children));
        }
        builder.append("]");
        return builder.toString();
    }
}

