/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.expressions;

import org.greenrobot.eclipse.core.expressions.ElementHandler;
import org.greenrobot.eclipse.core.expressions.Expression;
import org.greenrobot.eclipse.core.expressions.ExpressionConverter;
import org.greenrobot.eclipse.core.internal.expressions.AdaptExpression;
import org.greenrobot.eclipse.core.internal.expressions.AndExpression;
import org.greenrobot.eclipse.core.internal.expressions.CompositeExpression;
import org.greenrobot.eclipse.core.internal.expressions.CountExpression;
import org.greenrobot.eclipse.core.internal.expressions.EnablementExpression;
import org.greenrobot.eclipse.core.internal.expressions.EqualsExpression;
import org.greenrobot.eclipse.core.internal.expressions.InstanceofExpression;
import org.greenrobot.eclipse.core.internal.expressions.IterateExpression;
import org.greenrobot.eclipse.core.internal.expressions.NotExpression;
import org.greenrobot.eclipse.core.internal.expressions.OrExpression;
import org.greenrobot.eclipse.core.internal.expressions.ReferenceExpression;
import org.greenrobot.eclipse.core.internal.expressions.ResolveExpression;
import org.greenrobot.eclipse.core.internal.expressions.SystemTestExpression;
import org.greenrobot.eclipse.core.internal.expressions.TestExpression;
import org.greenrobot.eclipse.core.internal.expressions.WithExpression;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StandardElementHandler
extends ElementHandler {
    @Override
    public Expression create(ExpressionConverter converter, IConfigurationElement element) throws CoreException {
        String name = element.getName();
        if (name == null) {
            return null;
        }
        switch (name) {
            case "instanceof": {
                return new InstanceofExpression(element);
            }
            case "test": {
                return new TestExpression(element);
            }
            case "or": {
                OrExpression result = new OrExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "and": {
                AndExpression result = new AndExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "not": {
                return new NotExpression(converter.perform(element.getChildren()[0]));
            }
            case "with": {
                WithExpression result = new WithExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "adapt": {
                AdaptExpression result = new AdaptExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "iterate": {
                IterateExpression result = new IterateExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "count": {
                return new CountExpression(element);
            }
            case "systemTest": {
                return new SystemTestExpression(element);
            }
            case "resolve": {
                ResolveExpression result = new ResolveExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "enablement": {
                EnablementExpression result = new EnablementExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "equals": {
                return new EqualsExpression(element);
            }
            case "reference": {
                return new ReferenceExpression(element);
            }
        }
        return null;
    }

    @Override
    public Expression create(ExpressionConverter converter, Element element) throws CoreException {
        String name = element.getNodeName();
        if (name == null) {
            return null;
        }
        switch (name) {
            case "instanceof": {
                return new InstanceofExpression(element);
            }
            case "test": {
                return new TestExpression(element);
            }
            case "or": {
                OrExpression result = new OrExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "and": {
                AndExpression result = new AndExpression();
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "not": {
                Node child = element.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 1) {
                        return new NotExpression(converter.perform((Element)child));
                    }
                    child = child.getNextSibling();
                }
                break;
            }
            case "with": {
                WithExpression result = new WithExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "adapt": {
                AdaptExpression result = new AdaptExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "iterate": {
                IterateExpression result = new IterateExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "count": {
                return new CountExpression(element);
            }
            case "systemTest": {
                return new SystemTestExpression(element);
            }
            case "resolve": {
                ResolveExpression result = new ResolveExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "enablement": {
                EnablementExpression result = new EnablementExpression(element);
                this.processChildren(converter, element, (CompositeExpression)result);
                return result;
            }
            case "equals": {
                return new EqualsExpression(element);
            }
            case "reference": {
                return new ReferenceExpression(element);
            }
        }
        return null;
    }
}

