/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.filesystem.local.nio;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import org.greenrobot.eclipse.core.filesystem.IFileInfo;
import org.greenrobot.eclipse.core.filesystem.provider.FileInfo;
import org.greenrobot.eclipse.core.internal.filesystem.local.NativeHandler;

public class DosHandler
extends NativeHandler {
    private static final int ATTRIBUTES = 122;

    @Override
    public FileInfo fetchFileInfo(String fileName) {
        FileInfo info = new FileInfo();
        try {
            Path path = Paths.get(fileName, new String[0]);
            Path fileNamePath = path.toRealPath(LinkOption.NOFOLLOW_LINKS).getFileName();
            String canonicalName = fileNamePath == null ? "" : fileNamePath.toString();
            info.setName(canonicalName);
            DosFileAttributes attrs = Files.readAttributes(path, DosFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            info.setExists(true);
            info.setLastModified(attrs.lastModifiedTime().toMillis());
            info.setLength(attrs.size());
            info.setAttribute(8, attrs.isArchive());
            info.setAttribute(2, attrs.isReadOnly());
            info.setAttribute(16, attrs.isHidden());
            if (attrs.isSymbolicLink()) {
                info.setDirectory(this.isDirectoryLink(attrs));
                info.setAttribute(32, true);
                info.setStringAttribute(64, Files.readSymbolicLink(path).toString());
            } else {
                info.setDirectory(attrs.isDirectory());
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException iOException) {
            info.setError(5);
        }
        return info;
    }

    private boolean isDirectoryLink(DosFileAttributes attrs) {
        try {
            Method method = attrs.getClass().getDeclaredMethod("isDirectoryLink", new Class[0]);
            method.setAccessible(true);
            return (Boolean)method.invoke((Object)attrs, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return false;
        }
    }

    @Override
    public int getSupportedAttributes() {
        return 122;
    }

    @Override
    public boolean putFileInfo(String fileName, IFileInfo info, int options) {
        Path path = Paths.get(fileName, new String[0]);
        DosFileAttributeView view = Files.getFileAttributeView(path, DosFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        try {
            view.setArchive(info.getAttribute(8));
            view.setReadOnly(info.getAttribute(2));
            view.setHidden(info.getAttribute(16));
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

