/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.resources;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.greenrobot.eclipse.core.internal.resources.ResourceStatus;
import org.greenrobot.eclipse.core.resources.IResourceStatus;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.IStatus;

public class ResourceException
extends CoreException {
    private static final long serialVersionUID = 1L;

    public ResourceException(int code, IPath path, String message, Throwable exception) {
        super(new ResourceStatus(code, path, message, ResourceException.provideStackTrace(message, exception)));
    }

    private static Throwable provideStackTrace(String message, Throwable exception) {
        return exception != null ? exception : new Exception(message);
    }

    public ResourceException(IStatus status) {
        super(status);
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream output) {
        PrintStream printStream = output;
        synchronized (printStream) {
            IStatus status = this.getStatus();
            if (status.getException() != null) {
                String path = "()";
                if (status instanceof IResourceStatus) {
                    path = "(" + ((IResourceStatus)status).getPath() + ")";
                }
                output.print(String.valueOf(this.getClass().getName()) + path + "[" + status.getCode() + "]: ");
                status.getException().printStackTrace(output);
            } else {
                super.printStackTrace(output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter output) {
        PrintWriter printWriter = output;
        synchronized (printWriter) {
            IStatus status = this.getStatus();
            if (status.getException() != null) {
                String path = "()";
                if (status instanceof IResourceStatus) {
                    path = "(" + ((IResourceStatus)status).getPath() + ")";
                }
                output.print(String.valueOf(this.getClass().getName()) + path + "[" + status.getCode() + "]: ");
                status.getException().printStackTrace(output);
            } else {
                super.printStackTrace(output);
            }
        }
    }
}

