/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.resources.mapping;

import java.util.HashMap;
import java.util.Map;
import org.greenrobot.eclipse.core.internal.resources.mapping.ModelProviderDescriptor;
import org.greenrobot.eclipse.core.internal.utils.Policy;
import org.greenrobot.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.greenrobot.eclipse.core.resources.mapping.ModelProvider;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IExtension;
import org.greenrobot.eclipse.core.runtime.IExtensionPoint;
import org.greenrobot.eclipse.core.runtime.Platform;

public class ModelProviderManager {
    private static Map<String, IModelProviderDescriptor> descriptors;
    private static ModelProviderManager instance;

    public static synchronized ModelProviderManager getDefault() {
        if (instance == null) {
            instance = new ModelProviderManager();
        }
        return instance;
    }

    private void detectCycles() {
    }

    public IModelProviderDescriptor getDescriptor(String id) {
        this.lazyInitialize();
        return descriptors.get(id);
    }

    public IModelProviderDescriptor[] getDescriptors() {
        this.lazyInitialize();
        return descriptors.values().toArray(new IModelProviderDescriptor[descriptors.size()]);
    }

    public ModelProvider getModelProvider(String modelProviderId) throws CoreException {
        IModelProviderDescriptor desc = this.getDescriptor(modelProviderId);
        if (desc == null) {
            return null;
        }
        return desc.getModelProvider();
    }

    protected void lazyInitialize() {
        if (descriptors != null) {
            return;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.greenrobot.eclipse.core.resources", "modelProviders");
        IExtension[] extensions = point.getExtensions();
        descriptors = new HashMap<String, IModelProviderDescriptor>(extensions.length * 2 + 1);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            ModelProviderDescriptor desc = null;
            try {
                desc = new ModelProviderDescriptor(extension);
            }
            catch (CoreException e) {
                Policy.log(e);
            }
            if (desc != null) {
                descriptors.put(desc.getId(), desc);
            }
            ++n2;
        }
        this.detectCycles();
    }
}

