/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.resources.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import org.greenrobot.eclipse.core.resources.IMarkerDelta;
import org.greenrobot.eclipse.core.resources.IResource;
import org.greenrobot.eclipse.core.resources.IResourceDelta;
import org.greenrobot.eclipse.core.resources.IResourceDeltaVisitor;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.PlatformObject;

public final class ProposedResourceDelta
extends PlatformObject
implements IResourceDelta {
    protected static int KIND_MASK = 255;
    private HashMap<String, ProposedResourceDelta> children = new HashMap(8);
    private IPath movedFromPath;
    private IPath movedToPath;
    private IResource resource;
    private int status;

    public ProposedResourceDelta(IResource resource) {
        this.resource = resource;
    }

    @Override
    public void accept(IResourceDeltaVisitor visitor) throws CoreException {
        this.accept(visitor, 0);
    }

    @Override
    public void accept(IResourceDeltaVisitor visitor, boolean includePhantoms) throws CoreException {
        this.accept(visitor, includePhantoms ? 1 : 0);
    }

    @Override
    public void accept(IResourceDeltaVisitor visitor, int memberFlags) throws CoreException {
        if (!visitor.visit(this)) {
            return;
        }
        for (ProposedResourceDelta childDelta : this.children.values()) {
            childDelta.accept(visitor, memberFlags);
        }
    }

    protected void add(ProposedResourceDelta delta) {
        if (this.children.isEmpty() && this.status == 0) {
            this.setKind(4);
        }
        this.children.put(delta.getResource().getName(), delta);
    }

    protected void addFlags(int flags) {
        this.status |= flags & ~KIND_MASK;
    }

    @Override
    public IResourceDelta findMember(IPath path) {
        int segmentCount = path.segmentCount();
        if (segmentCount == 0) {
            return this;
        }
        ProposedResourceDelta current = this;
        int i = 0;
        while (i < segmentCount) {
            current = current.children.get(path.segment(i));
            if (current == null) {
                return null;
            }
            ++i;
        }
        return current;
    }

    @Override
    public IResourceDelta[] getAffectedChildren() {
        return this.getAffectedChildren(7, 0);
    }

    @Override
    public IResourceDelta[] getAffectedChildren(int kindMask) {
        return this.getAffectedChildren(kindMask, 0);
    }

    @Override
    public IResourceDelta[] getAffectedChildren(int kindMask, int memberFlags) {
        ArrayList<ProposedResourceDelta> result = new ArrayList<ProposedResourceDelta>();
        for (ProposedResourceDelta child : this.children.values()) {
            if ((child.getKind() & kindMask) == 0) continue;
            result.add(child);
        }
        return result.toArray(new IResourceDelta[result.size()]);
    }

    ProposedResourceDelta getChild(String name) {
        return this.children.get(name);
    }

    @Override
    public int getFlags() {
        return this.status & ~KIND_MASK;
    }

    @Override
    public IPath getFullPath() {
        return this.getResource().getFullPath();
    }

    @Override
    public int getKind() {
        return this.status & KIND_MASK;
    }

    @Override
    public IMarkerDelta[] getMarkerDeltas() {
        return new IMarkerDelta[0];
    }

    @Override
    public IPath getMovedFromPath() {
        return this.movedFromPath;
    }

    @Override
    public IPath getMovedToPath() {
        return this.movedToPath;
    }

    @Override
    public IPath getProjectRelativePath() {
        return this.getResource().getProjectRelativePath();
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    public void setFlags(int flags) {
        this.status = this.getKind() | flags & ~KIND_MASK;
    }

    protected void setKind(int kind) {
        this.status = this.getFlags() | kind & KIND_MASK;
    }

    protected void setMovedFromPath(IPath path) {
        this.movedFromPath = path;
    }

    protected void setMovedToPath(IPath path) {
        this.movedToPath = path;
    }

    public String toString() {
        return "ProposedDelta(" + this.resource + ')';
    }
}

