/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.greenrobot.eclipse.core.internal.utils.IStringPoolParticipant;
import org.greenrobot.eclipse.core.internal.utils.Messages;
import org.greenrobot.eclipse.core.internal.utils.Policy;
import org.greenrobot.eclipse.core.internal.utils.StringPool;
import org.greenrobot.eclipse.core.runtime.IProgressMonitor;
import org.greenrobot.eclipse.core.runtime.ISafeRunnable;
import org.greenrobot.eclipse.core.runtime.IStatus;
import org.greenrobot.eclipse.core.runtime.Platform;
import org.greenrobot.eclipse.core.runtime.SafeRunner;
import org.greenrobot.eclipse.core.runtime.Status;
import org.greenrobot.eclipse.core.runtime.jobs.IJobManager;
import org.greenrobot.eclipse.core.runtime.jobs.ISchedulingRule;
import org.greenrobot.eclipse.core.runtime.jobs.Job;
import org.greenrobot.eclipse.core.runtime.jobs.MultiRule;
import org.greenrobot.osgi.framework.Bundle;

public class StringPoolJob
extends Job {
    private static final long INITIAL_DELAY = 300000L;
    private static final long RESCHEDULE_DELAY = 900000L;
    private long lastDuration;
    private Map<IStringPoolParticipant, ISchedulingRule> participants = Collections.synchronizedMap(new HashMap(10));
    private final Bundle systemBundle = Platform.getBundle("org.greenrobot.eclipse.osgi");

    public StringPoolJob() {
        super(Messages.utils_stringJobName);
        this.setSystem(true);
        this.setPriority(50);
    }

    public void addStringPoolParticipant(IStringPoolParticipant participant, ISchedulingRule rule) {
        this.participants.put(participant, rule);
        if (this.getState() == 1) {
            this.wakeUp(300000L);
        } else {
            this.schedule(300000L);
        }
    }

    public void removeStringPoolParticipant(IStringPoolParticipant participant) {
        this.participants.remove(participant);
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        if (this.systemBundle.getState() == 16) {
            return Status.OK_STATUS;
        }
        Map.Entry[] entries = this.participants.entrySet().toArray(new Map.Entry[this.participants.size()]);
        ISchedulingRule[] rules = new ISchedulingRule[entries.length];
        IStringPoolParticipant[] toRun = new IStringPoolParticipant[entries.length];
        int i = 0;
        while (i < toRun.length) {
            toRun[i] = (IStringPoolParticipant)entries[i].getKey();
            rules[i] = (ISchedulingRule)entries[i].getValue();
            ++i;
        }
        ISchedulingRule rule = MultiRule.combine(rules);
        long start = -1L;
        int savings = 0;
        IJobManager jobManager = Job.getJobManager();
        try {
            jobManager.beginRule(rule, monitor);
            start = System.currentTimeMillis();
            savings = this.shareStrings(toRun, monitor);
        }
        finally {
            jobManager.endRule(rule);
        }
        if (start > 0L) {
            this.lastDuration = System.currentTimeMillis() - start;
            if (Policy.DEBUG_STRINGS) {
                Policy.debug("String sharing saved " + savings + " bytes in: " + this.lastDuration);
            }
        }
        long scheduleDelay = Math.max(900000L, this.lastDuration * 100L);
        if (Policy.DEBUG_STRINGS) {
            Policy.debug("Rescheduling string sharing job in: " + scheduleDelay);
        }
        this.schedule(scheduleDelay);
        return Status.OK_STATUS;
    }

    private int shareStrings(IStringPoolParticipant[] toRun, IProgressMonitor monitor) {
        final StringPool pool = new StringPool();
        IStringPoolParticipant[] iStringPoolParticipantArray = toRun;
        int n = toRun.length;
        int n2 = 0;
        while (n2 < n) {
            final IStringPoolParticipant current = iStringPoolParticipantArray[n2];
            if (monitor.isCanceled()) break;
            SafeRunner.run(new ISafeRunnable(){

                @Override
                public void handleException(Throwable exception) {
                }

                @Override
                public void run() {
                    current.shareStrings(pool);
                }
            });
            ++n2;
        }
        return pool.getSavedStringCount();
    }
}

